/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.genericsystem.kernel.AbstractTsDependencies;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.LifeManager;

class Vertex {
    private final long ts;
    private final Generic meta;
    private final List<Generic> supers;
    private final Serializable value;
    private final List<Generic> components;
    private final LifeManager lifeManager;
    private final Dependencies<Generic> dependencies;

    protected Vertex(Generic generic, long ts, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
        this.ts = ts;
        this.meta = meta != null ? meta : generic;
        this.value = value;
        for (Generic component : components) {
            assert (component != null && !this.equals(component));
        }
        this.components = Collections.unmodifiableList(new ArrayList<Generic>(components));
        this.supers = Collections.unmodifiableList(new ArrayList<Generic>(supers));
        this.lifeManager = new LifeManager(otherTs);
        this.dependencies = new AbstractTsDependencies<Generic>(){

            @Override
            public LifeManager getLifeManager() {
                return Vertex.this.lifeManager;
            }
        };
    }

    long getTs() {
        return this.ts;
    }

    Generic getMeta() {
        return this.meta;
    }

    List<Generic> getSupers() {
        return this.supers;
    }

    Serializable getValue() {
        return this.value;
    }

    List<Generic> getComponents() {
        return this.components;
    }

    LifeManager getLifeManager() {
        return this.lifeManager;
    }

    Dependencies<Generic> getDependencies() {
        return this.dependencies;
    }
}

