/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.genericsystem.api.defaults.DefaultVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statics {
    private static Logger log = LoggerFactory.getLogger(Statics.class);
    private static ThreadLocal<Long> threadDebugged = new ThreadLocal();
    public static final String ENGINE_VALUE = "Engine";
    public static final long MILLI_TO_NANOSECONDS = 1000000L;
    public static final int ATTEMPT_SLEEP = 15;
    public static final int ATTEMPTS = 50;
    public static final long GARBAGE_PERIOD = 1000L;
    public static final long GARBAGE_INITIAL_DELAY = 1000L;
    public static final long LIFE_TIMEOUT = 1386174608777L;

    public static void debugCurrentThread() {
        threadDebugged.set(System.currentTimeMillis());
    }

    public static void stopDebugCurrentThread() {
        threadDebugged.remove();
    }

    public static boolean isCurrentThreadDebugged() {
        return threadDebugged.get() != null;
    }

    public static void logTimeIfCurrentThreadDebugged(String message) {
        if (Statics.isCurrentThreadDebugged()) {
            log.info(message + " : " + (System.currentTimeMillis() - threadDebugged.get()));
        }
    }

    public static class Supers<T extends DefaultVertex<T>>
    extends ArrayList<T> {
        private static final long serialVersionUID = 6163099887384346235L;

        public Supers(List<T> adds) {
            adds.forEach(this::add);
        }

        public Supers(List<T> adds, T lastAdd) {
            this(adds);
            this.add(lastAdd);
        }

        public Supers(List<T> adds, List<T> otherAdds) {
            this(adds);
            otherAdds.forEach(this::add);
        }

        @Override
        public boolean add(T candidate) {
            for (DefaultVertex element : this) {
                if (!element.inheritsFrom(candidate)) continue;
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!candidate.inheritsFrom((DefaultVertex)it.next())) continue;
                it.remove();
            }
            return super.add(candidate);
        }
    }
}

