/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.GenericHandler;

public class Restructurator<T extends DefaultVertex<T>> {
    private final Context<T> context;

    Restructurator(Context<T> context) {
        this.context = context;
    }

    T rebuildAll(T toRebuild, Supplier<T> rebuilder, NavigableSet<T> dependenciesToRebuild) {
        dependenciesToRebuild.descendingSet().forEach(this.context::unplug);
        if (rebuilder != null) {
            ConvertMap convertMap = new ConvertMap();
            DefaultVertex build = (DefaultVertex)rebuilder.get();
            if (toRebuild != null) {
                dependenciesToRebuild.remove(toRebuild);
                convertMap.put(toRebuild, build);
                this.context.triggersMutation((DefaultVertex)toRebuild, build);
            }
            dependenciesToRebuild.forEach(x -> convertMap.convert(x));
            return (T)build;
        }
        return null;
    }

    private class ConvertMap
    extends HashMap<T, T> {
        private static final long serialVersionUID = 5003546962293036021L;

        private ConvertMap() {
        }

        private T convert(T oldDependency) {
            if (oldDependency.isAlive()) {
                return oldDependency;
            }
            Object newDependency = (DefaultVertex)this.get(oldDependency);
            if (newDependency == null) {
                if (oldDependency.isMeta()) {
                    assert (oldDependency.getSupers().size() == 1);
                    newDependency = Restructurator.this.context.setMeta(oldDependency.getComponents().size());
                } else {
                    List overrides = this.reasignSupers(oldDependency, new ArrayList());
                    List components = this.reasignComponents(oldDependency);
                    Object meta = this.reasignMeta(components, this.convert((DefaultVertex)oldDependency.getMeta()));
                    newDependency = new GenericHandler.AtomicHandler(Restructurator.this.context, meta, overrides, oldDependency.getValue(), components).resolve();
                }
                this.put((T)oldDependency, (T)newDependency);
            }
            return newDependency;
        }

        private List<T> reasignSupers(T oldDependency, List<T> supersReasign) {
            for (DefaultVertex ancestor : oldDependency.getSupers().stream().map(x -> this.convert(x)).collect(Collectors.toList())) {
                if (!ancestor.isAlive()) {
                    this.reasignSupers(ancestor, supersReasign);
                    continue;
                }
                supersReasign.add(ancestor);
            }
            return supersReasign;
        }

        private List<T> reasignComponents(T oldDependency) {
            return oldDependency.getComponents().stream().map(x -> this.convert(x)).filter(x -> x.isAlive()).collect(Collectors.toList());
        }

        private T reasignMeta(List<T> components, T meta) {
            if (components.size() != meta.getComponents().size()) {
                return this.reasignMeta(components, (DefaultVertex)meta.getSupers().get(0));
            }
            return meta;
        }

        @Override
        public T put(T oldDependency, T newDependency) {
            DefaultVertex result = (DefaultVertex)super.put(oldDependency, newDependency);
            Restructurator.this.context.triggersMutation(oldDependency, newDependency);
            return result;
        }
    }
}

