/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.genericsystem.api.defaults.DefaultLifeManager;
import org.genericsystem.api.exception.ConcurrencyControlException;
import org.genericsystem.api.exception.OptimisticLockConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeManager
implements DefaultLifeManager {
    protected static Logger log = LoggerFactory.getLogger(LifeManager.class);
    private long birthTs;
    private final AtomicLong lastReadTs;
    private long deathTs;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    LifeManager(long[] otherTs) {
        this.birthTs = otherTs[0];
        this.lastReadTs = new AtomicLong(otherTs[1]);
        this.deathTs = otherTs[2];
    }

    public void beginLife(long birthTs) {
        assert (this.birthTs == Long.MAX_VALUE || this.birthTs == 0L) : "Generic is already born";
        if (this.birthTs == Long.MAX_VALUE) {
            this.birthTs = birthTs;
        }
    }

    void cancelBeginLife() {
        assert (this.isWriteLockedByCurrentThread());
        this.birthTs = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(long contextTs) {
        if (contextTs < this.birthTs) {
            return false;
        }
        this.readLock();
        try {
            this.atomicAdjustLastReadTs(contextTs);
            boolean bl = contextTs >= this.birthTs && contextTs < this.deathTs;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public void checkMvcc(long contextTs) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        if (this.deathTs != Long.MAX_VALUE) {
            throw new OptimisticLockConstraintViolationException("Attempt to kill a generic that is already killed by another thread");
        }
        assert (this.isWriteLockedByCurrentThread());
        if (contextTs < this.lastReadTs.get()) {
            throw new ConcurrencyControlException("" + contextTs + " " + this.lastReadTs.get());
        }
    }

    public void kill(long contextTs) {
        assert (this.birthTs != 0L);
        assert (contextTs >= this.birthTs) : "Can not kill a generic that is not yet born";
        assert (this.deathTs == Long.MAX_VALUE) : "Can not kill a generic that will die in the future";
        assert (contextTs >= this.getLastReadTs()) : "Mvcc rule violation";
        this.atomicAdjustLastReadTs(contextTs);
        this.deathTs = contextTs;
    }

    void resurect() {
        assert (this.isWriteLockedByCurrentThread());
        this.deathTs = Long.MAX_VALUE;
    }

    public long getLastReadTs() {
        return this.lastReadTs.get();
    }

    public long getDeathTs() {
        return this.deathTs;
    }

    public void atomicAdjustLastReadTs(long contextTs) {
        long current = this.lastReadTs.get();
        if (contextTs <= current) {
            return;
        }
        while (!this.lastReadTs.compareAndSet(current = this.lastReadTs.get(), contextTs)) {
        }
    }

    public void writeLock() {
        this.lock.writeLock().lock();
    }

    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public long getBirthTs() {
        return this.birthTs;
    }

    public boolean willDie() {
        return this.deathTs != Long.MAX_VALUE;
    }
}

