/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.ExistsException;
import org.genericsystem.kernel.Context;

abstract class GenericHandler<T extends DefaultVertex<T>> {
    final Context<T> context;
    final T meta;
    T adjustedMeta;
    final List<T> overrides;
    List<T> supers;
    final Serializable value;
    final List<T> components;
    T gettable;

    GenericHandler(Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components) {
        assert (overrides != null);
        this.context = context;
        this.meta = meta != null ? meta : (DefaultVertex)context.getRoot();
        this.overrides = overrides;
        this.value = value;
        this.components = components;
        this.check();
        this.adjust();
    }

    private void check() {
        this.context.getChecker().checkBeforeBuild(this.meta, this.overrides, this.value, this.components);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMeta() {
        if (!Objects.equals(this.context.getRoot().getValue(), this.value)) return false;
        if (!this.components.stream().allMatch(this.context.getRoot()::equals)) return false;
        return true;
    }

    void adjust() {
        this.adjustedMeta = this.meta.adjustMeta(this.value, this.components);
        if (this.meta.isMeta() && this.adjustedMeta.getComponents().size() != this.components.size()) {
            if (this.isMeta()) {
                this.supers = Collections.singletonList(this.adjustedMeta);
                return;
            }
            this.adjustedMeta = this.context.setMeta(this.components.size());
        }
        this.supers = this.context.computeAndCheckOverridesAreReached(this.adjustedMeta, this.overrides, this.value, this.components);
    }

    T get() {
        if (this.gettable == null) {
            this.gettable = this.adjustedMeta.getDirectInstance(this.supers, this.value, this.components);
        }
        return this.gettable;
    }

    T getEquiv() {
        return (T)this.adjustedMeta.getDirectEquivInstance(this.value, this.components);
    }

    public T getOrBuild() {
        T instance = this.get();
        return instance == null ? this.build() : instance;
    }

    T build() {
        this.gettable = this.context.getBuilder().buildAndPlug(null, this.isMeta() ? null : (Object)this.adjustedMeta, this.supers, this.value, this.components);
        return this.gettable;
    }

    T add() {
        return (T)this.context.getRestructurator().rebuildAll(null, () -> this.build(), this.context.computePotentialDependencies((DefaultVertex)this.adjustedMeta, this.supers, this.value, this.components));
    }

    T set(T update) {
        assert (update != null);
        return (T)this.context.getRestructurator().rebuildAll((DefaultVertex)update, () -> this.build(), this.context.computeDependencies((DefaultVertex)update));
    }

    T update(T update) {
        assert (update != null);
        return (T)this.context.getRestructurator().rebuildAll((DefaultVertex)update, () -> this.getOrBuild(), this.context.computeDependencies((DefaultVertex)update));
    }

    static class SetArchiverHandler<T extends DefaultVertex<T>>
    extends AtomicHandler<T> {
        private final long ts;
        private final long[] otherTs;

        SetArchiverHandler(long ts, Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components, long[] otherTs) {
            super(context, meta, overrides, value, components);
            this.ts = ts;
            this.otherTs = otherTs;
        }

        @Override
        T build() {
            this.gettable = this.context.plug(this.context.getBuilder().build(this.ts, null, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components, this.otherTs));
            return (T)this.gettable;
        }
    }

    static class SetSystemHandler<T extends DefaultVertex<T>>
    extends AtomicHandler<T> {
        private final Class<?> clazz;

        SetSystemHandler(Context<T> context, Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
            this.clazz = clazz;
        }

        @Override
        T build() {
            this.gettable = this.context.getBuilder().buildAndPlug(this.clazz, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components);
            return (T)this.gettable;
        }
    }

    static class AtomicHandler<T extends DefaultVertex<T>>
    extends GenericHandler<T> {
        AtomicHandler(Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
        }

        final T resolve() {
            return this.getOrBuild();
        }
    }

    static class UpdateHandler<T extends DefaultVertex<T>>
    extends GenericHandler<T> {
        private final T update;

        UpdateHandler(Context<T> context, T update, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
            this.update = update;
        }

        T resolve() {
            return this.update(this.update);
        }
    }

    static class SetHandler<T extends DefaultVertex<T>>
    extends GenericHandler<T> {
        SetHandler(Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
        }

        T resolve() {
            Object generic = this.get();
            if (generic != null) {
                return generic;
            }
            generic = this.getEquiv();
            return generic == null ? this.add() : this.set(generic);
        }
    }

    static class AddHandler<T extends DefaultVertex<T>>
    extends GenericHandler<T> {
        AddHandler(Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
        }

        T resolve() {
            Object generic = this.get();
            if (generic != null) {
                this.context.discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
            }
            return this.add();
        }
    }

    static class GetHandler<T extends DefaultVertex<T>>
    extends GenericHandler<T> {
        GetHandler(Context<T> context, T gettable) {
            super(context, (DefaultVertex)gettable.getMeta(), gettable.getSupers(), gettable.getValue(), gettable.getComponents());
            this.gettable = gettable;
            this.adjustedMeta = (DefaultVertex)gettable.getMeta();
            this.supers = gettable.getSupers();
        }

        GetHandler(Context<T> context, T meta, List<T> overrides, Serializable value, List<T> components) {
            super(context, meta, overrides, value, components);
        }

        T resolve() {
            return this.get();
        }
    }
}

