/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.UnreachableOverridesException;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.GenericHandler;
import org.genericsystem.kernel.Restructurator;
import org.genericsystem.kernel.SupersComputer;

public abstract class Context<T extends DefaultVertex<T>>
implements DefaultContext<T> {
    private final DefaultRoot<T> root;
    private final Checker<T> checker;
    private final Builder<T> builder;
    private final Restructurator<T> restructurator;

    protected Context(DefaultRoot<T> root) {
        this.root = root;
        this.checker = this.buildChecker();
        this.builder = this.buildBuilder();
        this.restructurator = this.buildRestructurator();
    }

    public abstract long getTs();

    protected Checker<T> buildChecker() {
        return new Checker(this);
    }

    protected abstract Builder<T> buildBuilder();

    protected Restructurator<T> buildRestructurator() {
        return new Restructurator(this);
    }

    protected Checker<T> getChecker() {
        return this.checker;
    }

    Builder<T> getBuilder() {
        return this.builder;
    }

    Restructurator<T> getRestructurator() {
        return this.restructurator;
    }

    public DefaultRoot<T> getRoot() {
        return this.root;
    }

    public final T[] newTArray(int dim) {
        return this.builder.newTArray(dim);
    }

    T[] rootComponents(int dim) {
        Object[] components = this.newTArray(dim);
        Arrays.fill(components, this.root);
        return components;
    }

    List<T> computeAndCheckOverridesAreReached(T adjustedMeta, List<T> overrides, Serializable value, List<T> components) {
        ArrayList<T> supers = new ArrayList<T>(new SupersComputer<T>(adjustedMeta, overrides, value, components));
        if (!ApiStatics.areOverridesReached(supers, overrides)) {
            this.discardWithException((Throwable)new UnreachableOverridesException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
        return supers;
    }

    protected T getMeta(int dim) {
        DefaultVertex adjustedMeta = ((DefaultVertex)this.root).adjustMeta(this.root.getValue(), this.rootComponents(dim));
        return (T)(adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null);
    }

    T setMeta(int dim) {
        return (T)new GenericHandler.SetHandler<DefaultVertex>(this, null, Collections.emptyList(), this.getRoot().getValue(), Arrays.asList(this.rootComponents(dim))).resolve();
    }

    public T addInstance(T meta, List<T> overrides, Serializable value, List<T> components) {
        return new GenericHandler.AddHandler<T>(this, meta, overrides, value, components).resolve();
    }

    public T setInstance(T meta, List<T> overrides, Serializable value, List<T> components) {
        return new GenericHandler.SetHandler<T>(this, meta, overrides, value, components).resolve();
    }

    public T update(T update, List<T> overrides, Serializable newValue, List<T> newComponents) {
        return (T)new GenericHandler.UpdateHandler<DefaultVertex>(this, (DefaultVertex)update, (DefaultVertex)update.getMeta(), (List<DefaultVertex>)overrides, newValue, (List<DefaultVertex>)newComponents).resolve();
    }

    public void forceRemove(T generic) {
        this.getRestructurator().rebuildAll(null, null, this.builder.getContext().computeDependencies((DefaultVertex)generic));
    }

    public void remove(T generic) {
        this.getRestructurator().rebuildAll(null, null, this.builder.getContext().computeRemoveDependencies((DefaultVertex)generic));
    }

    public void conserveRemove(T generic) {
        this.getRestructurator().rebuildAll((DefaultVertex)generic, () -> generic, this.builder.getContext().computeDependencies((DefaultVertex)generic));
    }

    protected abstract T plug(T var1);

    protected abstract void unplug(T var1);

    protected void triggersMutation(T oldDependency, T newDependency) {
    }

    public abstract Snapshot<T> getDependencies(T var1);
}

