/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.CrossEnginesAssignementsException;
import org.genericsystem.api.exception.LevelConstraintViolationException;
import org.genericsystem.api.exception.MetaRuleConstraintViolationException;
import org.genericsystem.api.exception.NotAliveConstraintViolationException;
import org.genericsystem.api.exception.NotAllowedSerializableTypeException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.annotations.Priority;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public class Checker<T extends DefaultVertex<T>> {
    private final Context<T> context;
    private final Comparator<T> CONSTRAINT_PRIORITY = new Comparator<T>(){

        @Override
        public int compare(T constraintHolder, T compareConstraintHolder) {
            return Checker.this.getConstraintPriority((DefaultVertex)constraintHolder.getMeta()) < Checker.this.getConstraintPriority((DefaultVertex)compareConstraintHolder.getMeta()) ? -1 : 1;
        }
    };

    public Checker(Context<T> context) {
        this.context = context;
    }

    public Context<T> getContext() {
        return this.context;
    }

    public void checkBeforeBuild(T meta, List<T> overrides, Serializable value, List<T> components) throws RollbackException {
        this.checkSystemConstraintsBeforeBuild(meta, overrides, value, components);
    }

    public void checkAfterBuild(boolean isOnAdd, boolean isFlushTime, T vertex) throws RollbackException {
        this.checkSystemConstraintsAfterBuild(isOnAdd, isFlushTime, vertex);
        this.checkConsistency(vertex);
        this.checkConstraints(isOnAdd, isFlushTime, vertex);
    }

    private void checkSystemConstraintsBeforeBuild(T meta, List<T> overrides, Serializable value, List<T> components) {
        this.checkSameEngine(meta, overrides, components);
        this.checkIsAlive(meta, overrides, components);
        this.checkSerializableType(value);
        this.checkWellFormedMeta(meta, value, components);
    }

    private void checkSameEngine(T meta, List<T> overrides, List<T> components) {
        if (meta == null) {
            return;
        }
        DefaultRoot root = meta.getRoot();
        for (DefaultVertex component : components) {
            if (root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his component " + component + " because they are from differents engines"));
        }
        for (DefaultVertex directSuper : overrides) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkIsAlive(T meta, List<T> overrides, List<T> components) {
        if (meta != null) {
            this.checkIsAlive(meta);
        }
        overrides.forEach(x -> this.checkIsAlive(x));
        components.forEach(x -> this.checkIsAlive(x));
    }

    private void checkSerializableType(Serializable value) {
        if (value == null) {
            return;
        }
        if (value instanceof AxedPropertyClass) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof Float) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Class) {
            return;
        }
        this.context.discardWithException((Throwable)new NotAllowedSerializableTypeException("Not allowed type for your serializable. Only primitive and Byte[] allowed."));
    }

    private void checkWellFormedMeta(T meta, Serializable value, List<T> components) {
        if (meta == null && (components.stream().anyMatch(x -> !x.isRoot()) || !Objects.equals(value, this.context.getRoot().getValue()))) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : (" + meta + ") " + value + " " + components));
        }
    }

    private void checkWellFormedMeta(T vertex) {
        if (vertex.isMeta() && (vertex.getComponents().stream().anyMatch(c -> !c.isRoot()) || !Objects.equals(vertex.getValue(), this.context.getRoot().getValue()) || vertex.getSupers().size() != 1 || !((DefaultVertex)vertex.getSupers().get(0)).isMeta())) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : " + vertex.info()));
        }
    }

    protected void checkSystemConstraintsAfterBuild(boolean isOnAdd, boolean isFlushTime, T vertex) {
        this.checkWellFormedMeta(vertex);
        if (isOnAdd || !isFlushTime) {
            this.checkIsAlive(vertex);
        } else {
            this.checkIsNotAlive(vertex);
        }
        if (!isOnAdd) {
            this.checkDependenciesAreEmpty(vertex);
        }
        this.checkSameEngine(vertex);
        this.checkDependsMetaComponents(vertex);
        this.checkSupers(vertex);
        this.checkDependsSuperComponents(vertex);
        this.checkLevel(vertex);
        this.checkLevelComponents(vertex);
        this.checkSignatureUnicity(vertex);
        this.checkRemoveGenericAnnoted(isOnAdd, vertex);
    }

    private void checkRemoveGenericAnnoted(boolean isOnAdd, T vertex) {
        if (!isOnAdd && vertex.isSystem()) {
            this.getContext().discardWithException(new IllegalAccessException("System node can't be removed " + vertex.info()));
        }
    }

    private void checkIsAlive(T vertex) {
        if (!this.context.isAlive((DefaultVertex)vertex)) {
            this.context.discardWithException((Throwable)new AliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkIsNotAlive(T vertex) {
        if (this.context.isAlive((DefaultVertex)vertex)) {
            this.context.discardWithException((Throwable)new NotAliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkDependenciesAreEmpty(T vertex) {
        if (!this.context.getDependencies(vertex).isEmpty()) {
            this.context.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Unable to remove : " + vertex.info() + " cause it has dependencies"));
        }
    }

    private void checkSameEngine(T vertex) {
        DefaultRoot root = vertex.getRoot();
        for (DefaultVertex component : vertex.getComponents()) {
            if (root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his component " + component + " because they are from differents engines"));
        }
        for (DefaultVertex directSuper : vertex.getSupers()) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkDependsMetaComponents(T vertex) {
        if (((DefaultVertex)vertex.getMeta()).getComponents().size() != vertex.getComponents().size()) {
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Added generic and its meta do not have the same components size. Added node components : " + vertex.getComponents() + " and meta components : " + ((DefaultVertex)vertex.getMeta()).getComponents()));
        }
        for (int pos = 0; pos < vertex.getComponents().size(); ++pos) {
            Object component = vertex.getComponent(pos);
            DefaultVertex metaComponent = ((DefaultVertex)vertex.getMeta()).getComponent(pos);
            if (component == null) {
                if (metaComponent == null) continue;
                component = vertex;
            } else if (metaComponent == null) {
                metaComponent = (DefaultVertex)vertex.getMeta();
            }
            if (component.isInstanceOf(metaComponent) || component.inheritsFrom(metaComponent)) continue;
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Component of added generic : " + component + " must be instance of or must inherits from the component of its meta : " + metaComponent));
        }
    }

    private void checkSupers(T vertex) {
        if (!vertex.getSupers().stream().allMatch(superVertex -> superVertex.getLevel() == vertex.getLevel())) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers (bad level) : " + vertex.getSupers()));
        }
        if (!vertex.getSupers().stream().allMatch(superVertex -> ((DefaultVertex)vertex.getMeta()).inheritsFrom((DefaultVertex)superVertex.getMeta()))) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers : " + vertex.getSupers()));
        }
        if (!vertex.getSupers().stream().noneMatch(this::equals)) {
            this.context.discardWithException(new IllegalStateException("Supers loop detected : " + vertex.info()));
        }
    }

    private void checkDependsSuperComponents(T vertex) {
        vertex.getSupers().forEach(superVertex -> {
            if (!superVertex.isSuperOf((DefaultVertex)vertex.getMeta(), vertex.getSupers(), vertex.getValue(), vertex.getComponents())) {
                this.context.discardWithException(new IllegalStateException("Inconsistant components : " + vertex.getComponents()));
            }
        });
    }

    private void checkLevel(T vertex) {
        if (vertex.getLevel() > 2) {
            this.context.discardWithException((Throwable)new LevelConstraintViolationException("Unable to instanciate a concrete generic : " + vertex.getMeta()));
        }
    }

    private void checkLevelComponents(T vertex) {
        for (DefaultVertex component : vertex.getComponents()) {
            if (component.getLevel() <= vertex.getLevel()) continue;
            this.context.discardWithException((Throwable)new LevelConstraintViolationException("Inappropriate component meta level : " + component.getLevel() + " for component : " + component + ". Component meta level for added node is : " + vertex.getLevel()));
        }
    }

    private void checkSignatureUnicity(T vertex) {
    }

    private void checkConstraints(boolean isOnAdd, boolean isFlushTime, T vertex) {
        DefaultVertex map = (DefaultVertex)this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null) {
            Stream<DefaultVertex> contraintsHolders = ((DefaultVertex)vertex.getMeta()).getHolders(map).get().filter(holder -> ((DefaultVertex)holder.getMeta()).getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)((DefaultVertex)holder.getMeta()).getValue()).getClazz())).filter(holder -> holder.getValue() != null && !Boolean.FALSE.equals(holder.getValue())).sorted(this.CONSTRAINT_PRIORITY);
            contraintsHolders.forEach(constraintHolder -> {
                DefaultVertex targetComponent;
                DefaultVertex baseComponent = constraintHolder.getBaseComponent();
                if (vertex.isSpecializationOf(baseComponent)) {
                    this.check(constraintHolder, baseComponent, isFlushTime, isOnAdd, false, vertex);
                }
                if ((targetComponent = constraintHolder.getTargetComponent()) != null && vertex.isSpecializationOf(targetComponent)) {
                    this.check(constraintHolder, baseComponent, isFlushTime, isOnAdd, true, vertex);
                }
            });
        }
    }

    private void check(T constraintHolder, T baseComponent, boolean isFlushTime, boolean isOnAdd, boolean isRevert, T vertex) {
        try {
            this.statelessConstraint((DefaultVertex)constraintHolder.getMeta()).check(vertex, baseComponent, constraintHolder.getValue(), ((AxedPropertyClass)((DefaultVertex)constraintHolder.getMeta()).getValue()).getAxe(), isOnAdd, isFlushTime, isRevert);
        }
        catch (ConstraintViolationException e) {
            this.context.discardWithException(e);
        }
    }

    private Constraint<T> statelessConstraint(T vertex) {
        try {
            return (Constraint)((AxedPropertyClass)vertex.getValue()).getClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.context.discardWithException(e);
            return null;
        }
    }

    private int getConstraintPriority(T vertex) {
        Class clazz = ((AxedPropertyClass)vertex.getValue()).getClazz();
        Priority priority = clazz.getAnnotation(Priority.class);
        return priority != null ? priority.value() : 0;
    }

    private void checkConsistency(T vertex) {
        DefaultVertex map = (DefaultVertex)this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null && vertex.isInstanceOf(map) && ((DefaultVertex)vertex.getMeta()).getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)((DefaultVertex)vertex.getMeta()).getValue()).getClazz()) && vertex.getValue() != null && !Boolean.FALSE.equals(vertex.getValue())) {
            DefaultVertex baseConstraint = vertex.getComponent(0);
            int axe = ((AxedPropertyClass)((DefaultVertex)vertex.getMeta()).getValue()).getAxe();
            if (((AxedPropertyClass)((DefaultVertex)vertex.getMeta()).getValue()).getAxe() == -1) {
                baseConstraint.getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, false, x));
            } else {
                ((DefaultVertex)baseConstraint.getComponents().get(axe)).getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, true, x));
            }
        }
    }
}

