/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import org.genericsystem.api.defaults.DefaultLifeManager;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;
import org.genericsystem.kernel.annotations.InstanceClass;

public abstract class Builder<T extends DefaultVertex<T>> {
    private final Context<T> context;

    protected Builder(Context<T> context) {
        this.context = context;
    }

    public Context<T> getContext() {
        return this.context;
    }

    protected Class<T> getTClass() {
        return Generic.class;
    }

    public final T[] newTArray(int dim) {
        return (DefaultVertex[])Array.newInstance(this.getTClass(), dim);
    }

    protected T newT(Class<?> clazz, T meta) {
        InstanceClass metaAnnotation;
        InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
        if (metaAnnotation != null) {
            if (clazz == null || clazz.isAssignableFrom(metaAnnotation.value())) {
                clazz = metaAnnotation.value();
            } else if (!metaAnnotation.value().isAssignableFrom(clazz)) {
                this.getContext().discardWithException(new InstantiationException(clazz + " must extends " + metaAnnotation.value()));
            }
        }
        try {
            if (clazz == null || !this.getTClass().isAssignableFrom(clazz)) {
                return (T)((DefaultVertex)this.getTClass().newInstance());
            }
            return (T)((DefaultVertex)clazz.newInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            this.getContext().discardWithException(e);
            return null;
        }
    }

    abstract Class<?> getAnnotedClass(T var1);

    abstract T buildAndPlug(Class<?> var1, T var2, List<T> var3, Serializable var4, List<T> var5);

    abstract T build(long var1, Class<?> var3, T var4, List<T> var5, Serializable var6, List<T> var7, long[] var8);

    public static class GenericBuilder
    extends Builder<Generic> {
        public GenericBuilder(Context<Generic> context) {
            super(context);
        }

        @Override
        Generic build(long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
            return ((Root)this.getContext().getRoot()).init(this.newT(clazz, meta), ts, meta, supers, value, components, otherTs);
        }

        @Override
        Generic buildAndPlug(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
            return this.getContext().plug(this.build(((Root)this.getContext().getRoot()).pickNewTs(), clazz, meta, supers, value, components, ((Root)this.getContext().getRoot()).isInitialized() ? DefaultLifeManager.USER_TS : DefaultLifeManager.SYSTEM_TS));
        }

        @Override
        Class<?> getAnnotedClass(Generic vertex) {
            Class<?> annotedClass;
            if (vertex.isSystem() && (annotedClass = ((Root)this.getContext().getRoot()).findAnnotedClass(vertex)) != null) {
                return annotedClass;
            }
            return vertex.getClass();
        }
    }
}

