/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.genericsystem.kernel.DefaultGeneric;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.iterator.AbstractGeneralAwareIterator;

public abstract class AbstractTsDependencies<T extends DefaultGeneric>
implements Dependencies<T> {
    private Node<T> head = null;
    private Node<T> tail = null;
    private final ConcurrentHashMap<T, T> map = new ConcurrentHashMap();

    public abstract LifeManager getLifeManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object generic, long ts) {
        DefaultGeneric result = (DefaultGeneric)this.map.get(generic);
        if (result == null) {
            LifeManager lifeManager = this.getLifeManager();
            lifeManager.readLock();
            try {
                result = (DefaultGeneric)this.map.get(generic);
                lifeManager.atomicAdjustLastReadTs(ts);
            }
            finally {
                lifeManager.readUnlock();
            }
        }
        if (result != null && result.getLifeManager().isAlive(ts)) {
            return (T)result;
        }
        return null;
    }

    @Override
    public void add(T element) {
        assert (element != null);
        Node newNode = new Node(element);
        if (this.head == null) {
            this.head = newNode;
        } else {
            this.tail.next = newNode;
        }
        this.tail = newNode;
        DefaultGeneric result = (DefaultGeneric)this.map.put(element, element);
        assert (result == null) : result.info();
    }

    @Override
    public boolean remove(T generic) {
        assert (generic != null) : "generic is null";
        assert (this.head != null) : "head is null";
        Node<T> currentNode = this.head;
        DefaultGeneric currentContent = (DefaultGeneric)currentNode.content;
        if (generic.equals(currentContent)) {
            Node next = currentNode.next;
            this.head = next != null ? next : null;
            return true;
        }
        Node nextNode = currentNode.next;
        while (nextNode != null) {
            DefaultGeneric nextGeneric = (DefaultGeneric)nextNode.content;
            Node nextNextNode = nextNode.next;
            if (generic.equals(nextGeneric)) {
                nextNode.content = null;
                if (nextNextNode == null) {
                    this.tail = currentNode;
                }
                currentNode.next = nextNextNode;
                this.map.remove(generic);
                return true;
            }
            currentNode = nextNode;
            nextNode = nextNextNode;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator(long ts) {
        return new InternalIterator(ts);
    }

    private static class Node<T> {
        public T content;
        public Node<T> next;

        private Node(T content) {
            this.content = content;
        }
    }

    private class InternalIterator
    extends AbstractGeneralAwareIterator<Node<T>, T> {
        private final long ts;

        private InternalIterator(long iterationTs) {
            this.ts = iterationTs;
        }

        @Override
        protected void advance() {
            DefaultGeneric content;
            do {
                Node nextNode;
                Node node = nextNode = this.next == null ? AbstractTsDependencies.this.head : ((Node)this.next).next;
                if (nextNode == null) {
                    LifeManager lifeManager = AbstractTsDependencies.this.getLifeManager();
                    lifeManager.readLock();
                    try {
                        Node node2 = nextNode = this.next == null ? AbstractTsDependencies.this.head : ((Node)this.next).next;
                        if (nextNode == null) {
                            this.next = null;
                            lifeManager.atomicAdjustLastReadTs(this.ts);
                            return;
                        }
                    }
                    finally {
                        lifeManager.readUnlock();
                    }
                }
                this.next = nextNode;
            } while ((content = (DefaultGeneric)((Node)this.next).content) == null || !content.getLifeManager().isAlive(this.ts));
        }

        @Override
        protected T project() {
            return (DefaultGeneric)((Node)this.next).content;
        }
    }
}

