/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.iterator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.genericsystem.kernel.iterator.AbstractAwareIterator;

public abstract class AbstractConcateIterator<U, T>
extends AbstractAwareIterator<T>
implements Iterator<T> {
    private final Iterator<U> elements;
    private Iterator<T> iterator = Collections.emptyIterator();
    private final Set<T> alreadyAdded = new HashSet<T>();

    public AbstractConcateIterator(Iterator<U> elements) {
        this.elements = elements;
    }

    protected abstract Iterator<T> getIterator(U var1);

    @Override
    protected void advance() {
        while (true) {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.alreadyAdded.add(this.next)) continue;
                return;
            }
            if (!this.elements.hasNext()) {
                this.next = null;
                return;
            }
            this.iterator = this.getIterator(this.elements.next());
        }
    }

    public static class ConcateIterator<T>
    extends AbstractConcateIterator<Iterator<T>, T> {
        @SafeVarargs
        public ConcateIterator(Iterator<T> ... iterators) {
            super(Arrays.asList(iterators).iterator());
        }

        @Override
        protected Iterator<T> getIterator(Iterator<T> element) {
            return element;
        }
    }
}

