/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.api.defaults.DefaultBuilder;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.annotations.Components;
import org.genericsystem.kernel.annotations.Dependencies;
import org.genericsystem.kernel.annotations.Meta;
import org.genericsystem.kernel.annotations.Supers;
import org.genericsystem.kernel.annotations.constraints.InstanceValueClassConstraint;
import org.genericsystem.kernel.annotations.constraints.NoReferentialIntegrityProperty;
import org.genericsystem.kernel.annotations.constraints.PropertyConstraint;
import org.genericsystem.kernel.annotations.constraints.RequiredConstraint;
import org.genericsystem.kernel.annotations.constraints.SingularConstraint;
import org.genericsystem.kernel.annotations.constraints.UniqueValueConstraint;
import org.genericsystem.kernel.annotations.value.AxedPropertyClassValue;
import org.genericsystem.kernel.annotations.value.BooleanValue;
import org.genericsystem.kernel.annotations.value.ByteArrayValue;
import org.genericsystem.kernel.annotations.value.DoubleValue;
import org.genericsystem.kernel.annotations.value.EngineValue;
import org.genericsystem.kernel.annotations.value.FloatValue;
import org.genericsystem.kernel.annotations.value.IntValue;
import org.genericsystem.kernel.annotations.value.LongValue;
import org.genericsystem.kernel.annotations.value.ShortValue;
import org.genericsystem.kernel.annotations.value.StringValue;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;

public class SystemCache<T extends AbstractVertex<T>> {
    private final Map<Class<?>, T> systemCache = new HashMap();
    private final Map<T, Class<?>> reverseSystemCache = new IdentityHashMap();
    private boolean initialized = false;
    protected final DefaultRoot<T> root;

    public SystemCache(DefaultRoot<T> root, Class<?> rootClass) {
        this.root = root;
        this.put(rootClass, (AbstractVertex)root);
    }

    public void mount(List<Class<?>> systemClasses, Class<?> ... userClasses) {
        for (Class<?> clazz : systemClasses) {
            this.set(clazz);
        }
        for (Class<?> clazz : userClasses) {
            this.set(clazz);
        }
        this.initialized = true;
    }

    private T set(Class<?> clazz) {
        if (this.initialized) {
            throw new IllegalStateException("Class : " + clazz + " has not been built at startup");
        }
        AbstractVertex systemProperty = (AbstractVertex)this.systemCache.get(clazz);
        if (systemProperty != null) {
            assert (systemProperty.isAlive());
            return (T)systemProperty;
        }
        T meta = this.setMeta(clazz);
        List<T> overrides = this.setOverrides(clazz);
        List<T> components = this.setComponents(clazz);
        DefaultBuilder builder = ((AbstractVertex)this.root).getCurrentCache().getBuilder();
        if (meta == null) {
            assert (overrides.size() == 1);
        } else if (meta.isMeta()) {
            meta = builder.setMeta(components.size());
        }
        T result = builder.internalBuild(this.root.pickNewTs(), clazz, meta, overrides, this.findValue(clazz), components, Statics.SYSTEM_TS);
        this.put(clazz, result);
        this.mountConstraints(clazz, result);
        this.triggersDependencies(clazz);
        return result;
    }

    private void put(Class<?> clazz, T vertex) {
        this.systemCache.put(clazz, vertex);
        this.reverseSystemCache.put(vertex, clazz);
    }

    public T get(Class<?> clazz) {
        return (T)((AbstractVertex)this.systemCache.get(clazz));
    }

    public Class<?> getByVertex(T vertex) {
        return this.reverseSystemCache.get(vertex);
    }

    private void triggersDependencies(Class<?> clazz) {
        Dependencies dependenciesClass = clazz.getAnnotation(Dependencies.class);
        if (dependenciesClass != null) {
            for (Class dependencyClass : dependenciesClass.value()) {
                this.set(dependencyClass);
            }
        }
    }

    private void mountConstraints(Class<?> clazz, T result) {
        SingularConstraint singularTarget;
        NoReferentialIntegrityProperty referentialIntegrity;
        if (clazz.getAnnotation(PropertyConstraint.class) != null) {
            result.enablePropertyConstraint();
        }
        if (clazz.getAnnotation(UniqueValueConstraint.class) != null) {
            result.enableUniqueValueConstraint();
        }
        if (clazz.getAnnotation(InstanceValueClassConstraint.class) != null) {
            result.setClassConstraint(clazz.getAnnotation(InstanceValueClassConstraint.class).value());
        }
        if (clazz.getAnnotation(RequiredConstraint.class) != null) {
            result.enableRequiredConstraint(-1);
        }
        if ((referentialIntegrity = clazz.getAnnotation(NoReferentialIntegrityProperty.class)) != null) {
            for (int axe : referentialIntegrity.value()) {
                result.disableReferentialIntegrity(axe);
            }
        }
        if ((singularTarget = clazz.getAnnotation(SingularConstraint.class)) != null) {
            for (int axe : singularTarget.value()) {
                result.enableSingularConstraint(axe);
            }
        }
    }

    private T setMeta(Class<?> clazz) {
        Meta meta = clazz.getAnnotation(Meta.class);
        if (meta == null) {
            return (T)((AbstractVertex)this.root);
        }
        if (meta.value() == clazz) {
            return null;
        }
        return this.set(meta.value());
    }

    private List<T> setOverrides(Class<?> clazz) {
        ArrayList<T> overridesVertices = new ArrayList<T>();
        Supers supersAnnotation = clazz.getAnnotation(Supers.class);
        if (supersAnnotation != null) {
            for (Class overrideClass : supersAnnotation.value()) {
                overridesVertices.add(this.set(overrideClass));
            }
        }
        return overridesVertices;
    }

    private Serializable findValue(Class<?> clazz) {
        AxedPropertyClassValue axedPropertyClass = clazz.getAnnotation(AxedPropertyClassValue.class);
        if (axedPropertyClass != null) {
            return new AxedPropertyClass(axedPropertyClass.propertyClass(), axedPropertyClass.pos());
        }
        BooleanValue booleanValue = clazz.getAnnotation(BooleanValue.class);
        if (booleanValue != null) {
            return Boolean.valueOf(booleanValue.value());
        }
        ByteArrayValue byteArrayValue = clazz.getAnnotation(ByteArrayValue.class);
        if (byteArrayValue != null) {
            return byteArrayValue.value();
        }
        DoubleValue doubleValue = clazz.getAnnotation(DoubleValue.class);
        if (doubleValue != null) {
            return Double.valueOf(doubleValue.value());
        }
        EngineValue engineValue = clazz.getAnnotation(EngineValue.class);
        if (engineValue != null) {
            return this.root.getValue();
        }
        FloatValue floatValue = clazz.getAnnotation(FloatValue.class);
        if (floatValue != null) {
            return Float.valueOf(floatValue.value());
        }
        IntValue intValue = clazz.getAnnotation(IntValue.class);
        if (intValue != null) {
            return Integer.valueOf(intValue.value());
        }
        LongValue longValue = clazz.getAnnotation(LongValue.class);
        if (longValue != null) {
            return Long.valueOf(longValue.value());
        }
        ShortValue shortValue = clazz.getAnnotation(ShortValue.class);
        if (shortValue != null) {
            return Short.valueOf(shortValue.value());
        }
        StringValue stringValue = clazz.getAnnotation(StringValue.class);
        if (stringValue != null) {
            return stringValue.value();
        }
        return clazz;
    }

    private List<T> setComponents(Class<?> clazz) {
        ArrayList<T> components = new ArrayList<T>();
        Components componentsAnnotation = clazz.getAnnotation(Components.class);
        if (componentsAnnotation != null) {
            for (Class compositeClass : componentsAnnotation.value()) {
                if (compositeClass.equals(clazz)) {
                    components.add(null);
                    continue;
                }
                components.add(this.set(compositeClass));
            }
        }
        return components;
    }
}

