/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import java.util.NavigableSet;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Statics;

public class GenericHandler<T extends AbstractVertex<T>> {
    private final Builder<T> builder;
    private final Class<?> clazz;
    private final T meta;
    private T adjustedMeta;
    private List<T> overrides;
    private List<T> supers;
    private final Serializable value;
    private final List<T> components;
    private T gettable;

    public GenericHandler(Builder<T> builder, Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
        assert (overrides != null);
        this.builder = builder;
        this.clazz = clazz;
        this.meta = meta;
        this.overrides = overrides;
        this.value = value;
        this.components = components;
        this.check();
        this.adjustMeta();
        this.reComputeSupers();
    }

    public GenericHandler(T gettable) {
        this.builder = ((AbstractVertex)gettable).getCurrentCache().getBuilder();
        this.clazz = gettable.getClass();
        this.meta = ((AbstractVertex)gettable).getMeta();
        this.supers = ((AbstractVertex)gettable).getSupers();
        this.value = ((AbstractVertex)gettable).getValue();
        this.components = ((AbstractVertex)gettable).getComponents();
        this.gettable = gettable;
    }

    public void check() {
        this.builder.getContext().getChecker().checkBeforeBuild(this.clazz, this.meta, this.overrides, this.value, this.components);
    }

    public void adjustMeta() {
        this.adjustedMeta = this.meta.isMeta() ? this.builder.setMeta(this.components.size()) : ((AbstractVertex)this.meta).adjustMeta(this.value, this.components);
    }

    public void reComputeSupers() {
        assert (this.supers == null);
        this.supers = this.builder.computeAndCheckOverridesAreReached(this.adjustedMeta, this.overrides, this.value, this.components);
        if (this.supers.size() == 1 && ((AbstractVertex)this.supers.get(0)).equalsRegardlessSupers((ISignature<?>)this.adjustedMeta, this.value, (List<? extends ISignature<?>>)this.components) && Statics.areOverridesReached(((AbstractVertex)this.supers.get(0)).getSupers(), this.overrides)) {
            this.gettable = (AbstractVertex)this.supers.get(0);
            this.supers = ((AbstractVertex)this.supers.get(0)).getSupers();
        }
    }

    public T get() {
        assert (this.supers != null);
        return this.gettable;
    }

    public T getEquiv() {
        assert (this.adjustedMeta != null);
        return ((AbstractVertex)this.adjustedMeta).getDirectEquivInstance(this.value, this.components);
    }

    public T add() {
        assert (this.supers != null);
        return (T)this.builder.rebuildAll(null, () -> this.builder.build(this.clazz, this.adjustedMeta, this.supers, this.value, this.components), this.builder.getContext().computePotentialDependencies(this.adjustedMeta, this.supers, this.value, this.components));
    }

    public T set(T update) {
        assert (update != null);
        assert (this.supers != null);
        return (T)this.builder.rebuildAll((AbstractVertex)update, () -> this.builder.build(this.clazz, this.adjustedMeta, this.supers, this.value, this.components), (NavigableSet<AbstractVertex>)this.builder.getContext().computeDependencies(update, false, false));
    }

    public T update(T update) {
        assert (update != null);
        assert (this.supers != null);
        return (T)this.builder.rebuildAll((AbstractVertex)update, () -> this.builder.getOrBuild(this.clazz, this.adjustedMeta, this.supers, this.value, this.components), (NavigableSet<AbstractVertex>)this.builder.getContext().computeDependencies(update, false, false));
    }

    public void remove() {
        assert (this.supers != null);
        this.builder.rebuildAll(null, null, this.builder.getContext().computeDependencies(this.gettable, false, true));
    }

    public void forceRemove() {
        assert (this.supers != null);
        this.builder.rebuildAll(null, null, this.builder.getContext().computeDependencies(this.gettable, true, true));
    }

    public void conserveRemove() {
        assert (this.supers != null);
        this.builder.rebuildAll((AbstractVertex)this.gettable, () -> this.gettable, (NavigableSet<AbstractVertex>)this.builder.getContext().computeDependencies(this.gettable, false, false));
    }
}

