/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.kernel.AbstractVertex;

public class GarbageCollector<T extends AbstractVertex<T>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -2021341943811568201L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final DefaultRoot<T> root;

    public GarbageCollector(DefaultRoot<T> root) {
        this.root = root;
    }

    public void startScheduler() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                GarbageCollector.this.runGarbage(1386174608777L);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGarbage(long timeOut) {
        long ts = this.root.pickNewTs();
        DefaultRoot<T> defaultRoot = this.root;
        synchronized (defaultRoot) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AbstractVertex generic = (AbstractVertex)iterator.next();
                if (ts - generic.getLifeManager().getDeathTs() < timeOut) continue;
                generic.remove();
                iterator.remove();
            }
        }
    }
}

