/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.genericsystem.api.core.IteratorSnapshot;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.NotFoundException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Checker;

public abstract class Context<T extends AbstractVertex<T>>
implements DefaultContext<T> {
    private final DefaultRoot<T> root;
    private final Checker<T> checker;
    protected Builder<T> builder;

    protected Context(DefaultRoot<T> root) {
        this.root = root;
        this.checker = this.buildChecker();
        this.builder = this.buildBuilder();
    }

    public abstract long getTs();

    protected Checker<T> buildChecker() {
        return new Checker(this);
    }

    protected Builder<T> buildBuilder() {
        return new Builder(this);
    }

    public Checker<T> getChecker() {
        return this.checker;
    }

    public Builder<T> getBuilder() {
        return this.builder;
    }

    public DefaultRoot<T> getRoot() {
        return this.root;
    }

    public final boolean isAlive(T vertex) {
        return vertex != null && vertex.equals(this.getAlive(vertex));
    }

    protected T plug(T generic) {
        ((AbstractVertex)generic).getLifeManager().beginLife(this.getTs());
        return this.internalPlug(generic);
    }

    T internalPlug(T generic) {
        if (!generic.isMeta()) {
            this.indexInstance(((AbstractVertex)generic).getMeta(), generic);
        }
        ((AbstractVertex)generic).getSupers().forEach(superGeneric -> this.indexInheriting(superGeneric, generic));
        ((AbstractVertex)generic).getComponents().stream().filter(component -> component != null).distinct().forEach(component -> this.indexComposite(component, generic));
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    protected void unplug(T generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        ((AbstractVertex)generic).getLifeManager().kill(this.getTs());
    }

    void internalUnplug(T generic) {
        boolean result;
        boolean bl = result = generic != ((AbstractVertex)generic).getMeta() ? this.unIndexInstance(((AbstractVertex)generic).getMeta(), generic) : true;
        if (!result) {
            this.discardWithException((Throwable)new NotFoundException(generic.info()));
        }
        ((AbstractVertex)generic).getSupers().forEach(superGeneric -> this.unIndexInheriting(superGeneric, generic));
        ((AbstractVertex)generic).getComponents().stream().filter(component -> component != null).forEach(component -> this.unIndexComposite(component, generic));
    }

    public NavigableSet<T> computeDependencies(T node) {
        return this.computeDependencies(node, true, true);
    }

    NavigableSet<T> computeDependencies(T node, boolean force, boolean dependenciesToRemove) {
        return new OrderedDependencies(force, dependenciesToRemove).visit(node);
    }

    public NavigableSet<T> computePotentialDependencies(T meta, List<T> supers, Serializable value, List<T> components) {
        return new PotentialDependenciesComputer((AbstractVertex)meta, supers, value, components){
            private static final long serialVersionUID = -3611136800445783634L;
            final /* synthetic */ AbstractVertex val$meta;
            final /* synthetic */ List val$supers;
            final /* synthetic */ Serializable val$value;
            final /* synthetic */ List val$components;
            {
                this.val$meta = abstractVertex;
                this.val$supers = list;
                this.val$value = serializable;
                this.val$components = list2;
            }

            @Override
            boolean isSelected(T node) {
                return node.isDependencyOf((DefaultVertex)this.val$meta, this.val$supers, this.val$value, this.val$components);
            }
        }.visit(meta);
    }

    private T getAlive(T vertex) {
        if (vertex.isRoot()) {
            return vertex;
        }
        if (vertex.isMeta()) {
            AbstractVertex aliveSuper = this.getAlive((AbstractVertex)((AbstractVertex)vertex).getSupers().get(0));
            return (T)(aliveSuper != null ? (AbstractVertex)this.getInheritings((T)aliveSuper).get(vertex) : null);
        }
        Object aliveMeta = this.getAlive(((AbstractVertex)vertex).getMeta());
        return (T)(aliveMeta != null ? (AbstractVertex)this.getInstances(aliveMeta).get(vertex) : null);
    }

    protected T getMeta(int dim) {
        AbstractVertex adjustedMeta = this.getBuilder().adjustMeta((AbstractVertex)this.getRoot(), dim);
        return (T)(adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null);
    }

    public Snapshot<T> getInstances(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getInstancesDependencies().iterator(Context.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getInstancesDependencies().get(o, Context.this.getTs());
            }
        };
    }

    public Snapshot<T> getInheritings(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getInheritingsDependencies().iterator(Context.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getInheritingsDependencies().get(o, Context.this.getTs());
            }
        };
    }

    public Snapshot<T> getComposites(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getCompositesDependencies().iterator(Context.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getCompositesDependencies().get(o, Context.this.getTs());
            }
        };
    }

    protected void triggersMutation(T oldDependency, T newDependency) {
    }

    private void indexInstance(T generic, T instance) {
        ((AbstractVertex)generic).getInstancesDependencies().add(instance);
    }

    private void indexInheriting(T generic, T inheriting) {
        ((AbstractVertex)generic).getInheritingsDependencies().add(inheriting);
    }

    private void indexComposite(T generic, T composite) {
        ((AbstractVertex)generic).getCompositesDependencies().add(composite);
    }

    private boolean unIndexInstance(T generic, T instance) {
        return ((AbstractVertex)generic).getInstancesDependencies().remove(instance);
    }

    private boolean unIndexInheriting(T generic, T inheriting) {
        return ((AbstractVertex)generic).getInheritingsDependencies().remove(inheriting);
    }

    private boolean unIndexComposite(T generic, T composite) {
        return ((AbstractVertex)generic).getCompositesDependencies().remove(composite);
    }

    private abstract class PotentialDependenciesComputer
    extends TreeSet<T> {
        private static final long serialVersionUID = -5970021419012502402L;
        private final Set<T> alreadyVisited = new HashSet();

        private PotentialDependenciesComputer() {
        }

        abstract boolean isSelected(T var1);

        PotentialDependenciesComputer visit(T node) {
            if (!this.alreadyVisited.contains(node)) {
                if (this.isSelected(node)) {
                    super.addAll(Context.this.computeDependencies(node));
                } else {
                    this.alreadyVisited.add(node);
                    node.getComposites().forEach(this::visit);
                    node.getInheritings().forEach(this::visit);
                    node.getInstances().forEach(this::visit);
                }
            }
            return this;
        }
    }

    private class OrderedDependencies
    extends TreeSet<T> {
        private static final long serialVersionUID = -5970021419012502402L;
        private final boolean force;
        private final boolean dependenciesToRemove;

        public OrderedDependencies(boolean force, boolean dependenciesToRemove) {
            this.force = force;
            this.dependenciesToRemove = dependenciesToRemove;
        }

        protected void addDependecy(T dependency) {
            super.add(dependency);
        }

        OrderedDependencies visit(T node) {
            if (!this.contains(node)) {
                if (!this.force && this.dependenciesToRemove && !node.getInheritings().isEmpty()) {
                    Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a inheriting dependencies : " + node.getInheritings().info()));
                }
                Context.this.getInheritings(node).forEach(this::visit);
                if (!this.force && this.dependenciesToRemove && !node.getInstances().isEmpty()) {
                    Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a instance dependencies : " + node.getInstances().info()));
                }
                Context.this.getInstances(node).forEach(this::visit);
                for (AbstractVertex composite : node.getComposites()) {
                    if (!this.force) {
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (!((AbstractVertex)composite.getComponents().get(componentPos)).equals(node) || this.contains(composite) || !composite.getMeta().isReferentialIntegrityEnabled(componentPos)) continue;
                            Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + node + " by composite position : " + componentPos));
                        }
                    }
                    this.visit(composite);
                }
                this.addDependecy(node);
                for (int axe = 0; axe < ((AbstractVertex)node).getComponents().size(); ++axe) {
                    if (!node.isCascadeRemoveEnabled(axe)) continue;
                    this.visit((AbstractVertex)((AbstractVertex)node).getComponents().get(axe));
                }
            }
            return this;
        }
    }
}

