/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.api.defaults.DefaultBuilder;
import org.genericsystem.api.exception.ExistsException;
import org.genericsystem.api.exception.UnreachableOverridesException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.GenericHandler;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.SupersComputer;
import org.genericsystem.kernel.Vertex;
import org.genericsystem.kernel.annotations.InstanceClass;

public class Builder<T extends AbstractVertex<T>>
implements DefaultBuilder<T> {
    private final Context<T> context;

    protected Builder(Context<T> context) {
        this.context = context;
    }

    public Context<T> getContext() {
        return this.context;
    }

    protected Class<T> getTClass() {
        return Vertex.class;
    }

    protected Class<T> getSystemTClass() {
        return Vertex.SystemClass.class;
    }

    public final T[] newTArray(int dim) {
        return (AbstractVertex[])Array.newInstance(this.getTClass(), dim);
    }

    protected T newT(Class<?> clazz, T meta) {
        InstanceClass metaAnnotation;
        InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
        if (metaAnnotation != null) {
            if (clazz == null || clazz.isAssignableFrom(metaAnnotation.value())) {
                clazz = metaAnnotation.value();
            } else if (!metaAnnotation.value().isAssignableFrom(clazz)) {
                this.getContext().discardWithException((Throwable)new InstantiationException(clazz + " must extends " + metaAnnotation.value()));
            }
        }
        try {
            if (clazz == null) {
                return (T)((AbstractVertex)this.getTClass().newInstance());
            }
            if (!this.getTClass().isAssignableFrom(clazz)) {
                return (T)((AbstractVertex)this.getSystemTClass().newInstance());
            }
            return (T)((AbstractVertex)clazz.newInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            this.getContext().discardWithException((Throwable)e);
            return null;
        }
    }

    Class<?> getAnnotedClass(T vertex) {
        Class<?> vertexClass = vertex.getClass();
        if (vertexClass.equals(this.context.getBuilder().getSystemTClass())) {
            return this.context.getRoot().findAnnotedClass(vertex);
        }
        return vertexClass;
    }

    T setMeta(int dim) {
        AbstractVertex root = (AbstractVertex)this.context.getRoot();
        AbstractVertex adjustedMeta = this.adjustMeta(root, dim);
        if (adjustedMeta.getComponents().size() == dim) {
            return (T)adjustedMeta;
        }
        Object[] components = this.newTArray(dim);
        Arrays.fill(components, root);
        return (T)this.rebuildAll(null, () -> this.lambda$setMeta$22(adjustedMeta, root, (AbstractVertex[])components), this.context.computePotentialDependencies(adjustedMeta, Collections.singletonList(adjustedMeta), root.getValue(), Arrays.asList(components)));
    }

    T adjustMeta(T meta, int dim) {
        assert (meta.isMeta());
        int size = ((AbstractVertex)meta).getComponents().size();
        if (size > dim) {
            return null;
        }
        if (size == dim) {
            return meta;
        }
        AbstractVertex directInheriting = (AbstractVertex)meta.getInheritings().first();
        return (T)(directInheriting != null && directInheriting.getComponents().size() <= dim ? this.adjustMeta(directInheriting, dim) : meta);
    }

    protected T getOrBuild(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components) {
        T instance = meta == null ? this.getContext().getMeta(components.size()) : ((AbstractVertex)meta).getDirectInstance(value, components);
        return instance == null ? this.build(clazz, meta, supers, value, components) : instance;
    }

    T internalBuild(long ts, Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components, long[] otherTs) {
        return this.context.internalPlug(((AbstractVertex)this.newT(clazz, meta)).init(ts, meta, supers, value, components, otherTs));
    }

    T build(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components) {
        return this.context.plug(((AbstractVertex)this.newT(clazz, meta)).init(this.getContext().getRoot().pickNewTs(), meta, supers, value, components, new long[]{Long.MAX_VALUE, 0L, Long.MAX_VALUE}));
    }

    public void forceRemove(T generic) {
        new GenericHandler<T>(generic).forceRemove();
    }

    public void remove(T generic) {
        new GenericHandler<T>(generic).remove();
    }

    public void conserveRemove(T generic) {
        new GenericHandler<T>(generic).conserveRemove();
    }

    T rebuildAll(T toRebuild, Supplier<T> rebuilder, NavigableSet<T> dependenciesToRebuild) {
        dependenciesToRebuild.descendingSet().forEach(((Context)this.getContext())::unplug);
        if (rebuilder != null) {
            ConvertMap convertMap = new ConvertMap();
            AbstractVertex build = (AbstractVertex)rebuilder.get();
            if (toRebuild != null) {
                dependenciesToRebuild.remove(toRebuild);
                convertMap.put(toRebuild, build);
                this.getContext().triggersMutation(toRebuild, build);
            }
            dependenciesToRebuild.forEach(x -> convertMap.convert(x));
            return (T)build;
        }
        return null;
    }

    public T setInstance(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
        GenericHandler<T> genericBuilder = new GenericHandler<T>(this, clazz, meta, overrides, value, components);
        T generic = genericBuilder.get();
        if (generic != null) {
            return generic;
        }
        generic = genericBuilder.getEquiv();
        return generic == null ? genericBuilder.add() : genericBuilder.set(generic);
    }

    public T update(T update, List<T> overrides, Serializable newValue, List<T> newComponents) {
        return new GenericHandler<T>(this, update.getClass(), ((AbstractVertex)update).getMeta(), overrides, newValue, newComponents).update(update);
    }

    public T addInstance(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
        GenericHandler<T> genericBuilder = new GenericHandler<T>(this, clazz, meta, overrides, value, components);
        T generic = genericBuilder.get();
        if (generic != null) {
            this.getContext().discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
        }
        return genericBuilder.add();
    }

    private List<T> transform(T node, Function<T, List<T>> getDependencies) {
        List<T> dependencies = getDependencies.apply(node);
        for (int i = 0; i < dependencies.size(); ++i) {
            AbstractVertex dependency = (AbstractVertex)dependencies.get(i);
            if (dependency.isAlive()) continue;
            dependencies.addAll(this.transform(dependency, getDependencies));
            dependencies.remove(i);
        }
        return dependencies;
    }

    private T transformMeta(List<T> components, T meta) {
        if (components.size() != ((AbstractVertex)meta).getComponents().size()) {
            return (T)this.transformMeta(components, (AbstractVertex)((AbstractVertex)meta).getSupers().get(0));
        }
        return meta;
    }

    List<T> computeAndCheckOverridesAreReached(T adjustedMeta, List<T> overrides, Serializable value, List<T> components) {
        ArrayList<T> supers = new ArrayList<T>(new SupersComputer<T>(adjustedMeta, overrides, value, components));
        if (!Statics.areOverridesReached(supers, overrides)) {
            this.getContext().discardWithException((Throwable)new UnreachableOverridesException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
        return supers;
    }

    private /* synthetic */ AbstractVertex lambda$setMeta$22(AbstractVertex abstractVertex, AbstractVertex abstractVertex2, AbstractVertex[] abstractVertexArray) {
        return this.build(null, null, Collections.singletonList(abstractVertex), abstractVertex2.getValue(), Arrays.asList(abstractVertexArray));
    }

    private class ConvertMap
    extends HashMap<T, T> {
        private static final long serialVersionUID = 5003546962293036021L;
        Function<List<T>, List<T>> CONVERT_LIST = t -> t.stream().map(x -> this.convert(x)).collect(Collectors.toList());

        private ConvertMap() {
        }

        private T convert(T oldDependency) {
            if (((AbstractVertex)oldDependency).isAlive()) {
                return oldDependency;
            }
            AbstractVertex newDependency = (AbstractVertex)this.get(oldDependency);
            if (newDependency == null) {
                if (oldDependency.isMeta()) {
                    assert (((AbstractVertex)oldDependency).getSupers().size() == 1);
                    newDependency = Builder.this.setMeta(((AbstractVertex)oldDependency).getComponents().size());
                } else {
                    List overrides = Builder.this.transform(oldDependency, x -> this.CONVERT_LIST.apply(x.getSupers()));
                    List components = Builder.this.transform(oldDependency, x -> this.CONVERT_LIST.apply(x.getComponents()));
                    Object adjustedMeta = Builder.this.transformMeta(components, this.convert(((AbstractVertex)oldDependency).getMeta())).adjustMeta(((AbstractVertex)oldDependency).getValue(), components);
                    List supers = Builder.this.computeAndCheckOverridesAreReached(adjustedMeta, overrides, ((AbstractVertex)oldDependency).getValue(), components);
                    newDependency = Builder.this.getOrBuild(oldDependency.getClass(), adjustedMeta, supers, ((AbstractVertex)oldDependency).getValue(), components);
                }
                this.put((T)oldDependency, (T)newDependency);
            }
            return newDependency;
        }

        @Override
        public T put(T oldDependency, T newDependency) {
            AbstractVertex result = (AbstractVertex)super.put(oldDependency, newDependency);
            Builder.this.getContext().triggersMutation(oldDependency, newDependency);
            return result;
        }
    }
}

