/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.AmbiguousSelectionException;
import org.genericsystem.kernel.AbstractTsDependencies;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Statics;

public abstract class AbstractVertex<T extends AbstractVertex<T>>
implements DefaultVertex<T>,
Comparable<T> {
    private long ts;
    private T meta;
    private List<T> components;
    private Serializable value;
    private List<T> supers;
    private LifeManager lifeManager;

    protected T init(long ts, T meta, List<T> supers, Serializable value, List<T> components, long[] otherTs) {
        this.ts = ts;
        this.meta = meta != null ? meta : this;
        this.value = value;
        this.components = Collections.unmodifiableList(new ArrayList<T>(components));
        this.supers = Collections.unmodifiableList(new ArrayList<T>(supers));
        this.lifeManager = new LifeManager(otherTs);
        return (T)this;
    }

    public long getTs() {
        return this.ts;
    }

    public LifeManager getLifeManager() {
        return this.lifeManager;
    }

    public final boolean isAlive() {
        return this.getCurrentCache().isAlive(this);
    }

    protected boolean isAlive(long ts) {
        return this.getLifeManager().isAlive(ts);
    }

    @Override
    public int compareTo(T vertex) {
        long compareBirthTs;
        long birthTs = this.lifeManager.getBirthTs();
        return birthTs == (compareBirthTs = ((AbstractVertex)vertex).getLifeManager().getBirthTs()) ? Long.compare(this.getTs(), ((AbstractVertex)vertex).getTs()) : Long.compare(birthTs, compareBirthTs);
    }

    public T getMeta() {
        return this.meta;
    }

    public List<T> getComponents() {
        return this.components;
    }

    public Serializable getValue() {
        return this.value;
    }

    public List<T> getSupers() {
        return this.supers;
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }

    protected abstract Dependencies<T> getInstancesDependencies();

    protected abstract Dependencies<T> getInheritingsDependencies();

    protected abstract Dependencies<T> getCompositesDependencies();

    protected Dependencies<T> buildDependencies() {
        return new AbstractTsDependencies<T>(){

            @Override
            public LifeManager getLifeManager() {
                return AbstractVertex.this.getLifeManager();
            }
        };
    }

    public Context<T> getCurrentCache() {
        return (Context)this.getRoot().getCurrentCache();
    }

    protected T adjustMeta(Serializable value, T ... components) {
        return this.adjustMeta(value, Arrays.asList(components));
    }

    T adjustMeta(Serializable value, List<T> components) {
        AbstractVertex result = null;
        if (!components.equals(this.getComponents())) {
            for (AbstractVertex directInheriting : this.getInheritings()) {
                if (!this.componentsDepends(components, directInheriting.getComponents())) continue;
                if (result == null) {
                    result = directInheriting;
                    continue;
                }
                this.getCurrentCache().discardWithException((Throwable)new AmbiguousSelectionException("Ambigous selection : " + result.info() + directInheriting.info()));
            }
        }
        return (T)(result == null ? this : result.adjustMeta(value, components));
    }

    protected T getDirectInstance(Serializable value, List<T> components) {
        if (this.isMeta() && this.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) {
            return (T)this;
        }
        for (AbstractVertex instance : this.getInstances()) {
            if (!instance.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) continue;
            return (T)instance;
        }
        return null;
    }

    T getDirectInstance(List<T> overrides, Serializable value, List<T> components) {
        T result = this.getDirectInstance(value, components);
        return result != null && Statics.areOverridesReached(((AbstractVertex)result).getSupers(), overrides) ? (T)result : null;
    }

    T getDirectEquivInstance(Serializable value, List<T> components) {
        if (this.isMeta() && this.equalsRegardlessSupers((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) {
            return (T)this;
        }
        for (AbstractVertex instance : this.getInstances()) {
            if (!instance.equiv((ISignature<?>)this, value, (List<? extends ISignature<?>>)components)) continue;
            return (T)instance;
        }
        return null;
    }

    public T getInstance(List<T> overrides, Serializable value, T ... components) {
        List<T> componentsList = Arrays.asList(components);
        T adjustMeta = this.adjustMeta(value, componentsList);
        if (((AbstractVertex)adjustMeta).getComponents().size() < components.length) {
            return null;
        }
        return ((AbstractVertex)adjustMeta).getDirectInstance(overrides, value, componentsList);
    }

    boolean equalsAndOverrides(T meta, List<T> overrides, Serializable value, List<T> components) {
        return this.equalsRegardlessSupers((ISignature<?>)meta, value, (List<? extends ISignature<?>>)components) && Statics.areOverridesReached(this.getSupers(), overrides);
    }

    boolean equals(ISignature<?> meta, List<? extends ISignature<?>> supers, Serializable value, List<? extends ISignature<?>> components) {
        return this.equalsRegardlessSupers(meta, value, components) && this.getSupers().equals(supers);
    }

    boolean equalsRegardlessSupers(ISignature<?> meta, Serializable value, List<? extends ISignature<?>> components) {
        if (!this.getMeta().equals(meta == null ? this : meta)) {
            return false;
        }
        if (!Objects.equals(this.getValue(), value)) {
            return false;
        }
        List<T> componentsList = this.getComponents();
        if (componentsList.size() != components.size()) {
            return false;
        }
        return componentsList.equals(components);
    }

    public boolean genericEquals(ISignature<?> service) {
        if (service == null) {
            return false;
        }
        if (this == service) {
            return true;
        }
        if (!((AbstractVertex)this.getMeta()).genericEquals((ISignature<?>)(service == service.getMeta() ? this : service.getMeta()))) {
            return false;
        }
        if (!Objects.equals(this.getValue(), service.getValue())) {
            return false;
        }
        List<T> componentsList = this.getComponents();
        if (componentsList.size() != service.getComponents().size()) {
            return false;
        }
        for (int i = 0; i < componentsList.size(); ++i) {
            if (AbstractVertex.genericEquals((AbstractVertex)componentsList.get(i), (ISignature)service.getComponents().get(i))) continue;
            return false;
        }
        List<T> supersList = this.getSupers();
        if (supersList.size() != service.getSupers().size()) {
            return false;
        }
        for (int i = 0; i < supersList.size(); ++i) {
            if (((AbstractVertex)supersList.get(i)).genericEquals((ISignature)service.getSupers().get(i))) continue;
            return false;
        }
        return true;
    }

    static <T extends AbstractVertex<T>> boolean genericEquals(AbstractVertex<T> component, ISignature<?> compare) {
        return component == compare || component != null && component.genericEquals(compare);
    }

    private static <T extends AbstractVertex<T>> boolean equiv(T component, ISignature<?> compare) {
        return component == compare || component != null && component.equiv(compare);
    }

    boolean equiv(ISignature<? extends ISignature<?>> service) {
        if (service == null) {
            return false;
        }
        if (this == service) {
            return true;
        }
        return this.equiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    boolean equiv(ISignature<?> meta, Serializable value, List<? extends ISignature<?>> components) {
        int i;
        if (!this.getMeta().equals(meta == null ? this : meta)) {
            return false;
        }
        List<T> componentsList = this.getComponents();
        if (componentsList.size() != components.size()) {
            return false;
        }
        for (i = 0; i < componentsList.size(); ++i) {
            if (this.isReferentialIntegrityEnabled(i) || !this.isSingularConstraintEnabled(i)) continue;
            return AbstractVertex.equiv((AbstractVertex)componentsList.get(i), components.get(i));
        }
        for (i = 0; i < componentsList.size(); ++i) {
            if (AbstractVertex.equiv((AbstractVertex)componentsList.get(i), components.get(i))) continue;
            return false;
        }
        if (!this.getMeta().isPropertyConstraintEnabled()) {
            return Objects.equals(this.getValue(), value);
        }
        return true;
    }

    public T getMap() {
        return (T)((AbstractVertex)this.getRoot().find(Config.SystemMap.class));
    }
}

