/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Iterator;
import org.genericsystem.api.core.IteratorSnapshot;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.exception.NotFoundException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Context;

public class Transaction<T extends AbstractVertex<T>>
extends Context<T> {
    private final long ts;

    protected Transaction(DefaultRoot<T> root, long ts) {
        super(root);
        this.ts = ts;
    }

    @Override
    protected T plug(T generic) {
        if (!generic.isMeta()) {
            this.indexInstance(((AbstractVertex)generic).getMeta(), generic);
        }
        ((AbstractVertex)generic).getSupers().forEach(superGeneric -> this.indexInheriting(superGeneric, generic));
        ((AbstractVertex)generic).getComponents().stream().filter(component -> component != null).distinct().forEach(component -> this.indexComposite(component, generic));
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    @Override
    protected void unplug(T generic) {
        boolean result;
        this.getChecker().checkAfterBuild(false, false, generic);
        boolean bl = result = generic != ((AbstractVertex)generic).getMeta() ? this.unIndexInstance(((AbstractVertex)generic).getMeta(), generic) : true;
        if (!result) {
            this.discardWithException((Throwable)new NotFoundException(generic.info()));
        }
        ((AbstractVertex)generic).getSupers().forEach(superGeneric -> this.unIndexInheriting(superGeneric, generic));
        ((AbstractVertex)generic).getComponents().stream().filter(component -> component != null).forEach(component -> this.unIndexComposite(component, generic));
    }

    private void indexInstance(T generic, T instance) {
        ((AbstractVertex)generic).getInstancesDependencies().add(instance);
    }

    private void indexInheriting(T generic, T inheriting) {
        ((AbstractVertex)generic).getInheritingsDependencies().add(inheriting);
    }

    private void indexComposite(T generic, T composite) {
        ((AbstractVertex)generic).getCompositesDependencies().add(composite);
    }

    private boolean unIndexInstance(T generic, T instance) {
        return ((AbstractVertex)generic).getInstancesDependencies().remove(instance);
    }

    private boolean unIndexInheriting(T generic, T inheriting) {
        return ((AbstractVertex)generic).getInheritingsDependencies().remove(inheriting);
    }

    private boolean unIndexComposite(T generic, T composite) {
        return ((AbstractVertex)generic).getCompositesDependencies().remove(composite);
    }

    @Override
    public Snapshot<T> getInstances(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getInstancesDependencies().iterator(Transaction.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getInstancesDependencies().get(o, Transaction.this.getTs());
            }
        };
    }

    @Override
    public Snapshot<T> getInheritings(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getInheritingsDependencies().iterator(Transaction.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getInheritingsDependencies().get(o, Transaction.this.getTs());
            }
        };
    }

    @Override
    public Snapshot<T> getComposites(T vertex) {
        return new IteratorSnapshot<T>((AbstractVertex)vertex){
            final /* synthetic */ AbstractVertex val$vertex;
            {
                this.val$vertex = abstractVertex;
            }

            public Iterator<T> iterator() {
                return this.val$vertex.getCompositesDependencies().iterator(Transaction.this.getTs());
            }

            public T get(Object o) {
                return (AbstractVertex)this.val$vertex.getCompositesDependencies().get(o, Transaction.this.getTs());
            }
        };
    }

    @Override
    public final long getTs() {
        return this.ts;
    }

    @Override
    protected Builder<T> buildBuilder() {
        return new Context.AbstractVertexBuilder(this);
    }
}

