/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.kernel.Archiver;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.SystemCache;
import org.genericsystem.kernel.Transaction;
import org.genericsystem.kernel.Vertex;

public class Root
extends Vertex
implements DefaultRoot<Vertex> {
    private final Context<Vertex> context;
    private final SystemCache<Vertex> systemCache = new SystemCache<Vertex>(this, this.getClass());
    private final Archiver<Vertex> archiver;

    public Root(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Root(Serializable value, Class<?> ... userClasses) {
        this(value, (String)null, userClasses);
    }

    public Root(Serializable value, String persistentDirectoryPath, Class<?> ... userClasses) {
        this.init(null, Collections.emptyList(), value, Collections.emptyList());
        this.context = new Transaction<Vertex>(this, 0L);
        this.systemCache.mount(Arrays.asList(Config.MetaAttribute.class, Config.MetaRelation.class, Config.SystemMap.class), userClasses);
        this.archiver = new Archiver<Vertex>(this, persistentDirectoryPath);
    }

    public final Vertex getMetaAttribute() {
        return this.find(Config.MetaAttribute.class);
    }

    public final Vertex getMetaRelation() {
        return this.find(Config.MetaRelation.class);
    }

    @Override
    public Context<Vertex> getCurrentCache() {
        return this.context;
    }

    public <Custom extends Vertex> Custom find(Class<?> clazz) {
        return (Custom)this.systemCache.get(clazz);
    }

    public Class<?> findAnnotedClass(Vertex vertex) {
        return this.systemCache.getByVertex(vertex);
    }

    public void close() {
        this.archiver.close();
    }
}

