/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.genericsystem.api.core.IteratorSnapshot;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.iterator.AbstractGeneralAwareIterator;

public class DependenciesImpl<T>
implements Dependencies<T>,
IteratorSnapshot<T> {
    private Node<T> head = null;
    private Node<T> tail = null;
    final Map<T, T> map = new HashMap<T, T>();

    @Override
    public void add(T element) {
        assert (element != null);
        Node newNode = new Node(element);
        if (this.head == null) {
            this.head = newNode;
        } else {
            ((Node)this.tail).next = newNode;
        }
        this.tail = newNode;
        this.map.put(element, element);
    }

    @Override
    public boolean remove(T element) {
        Iterator<T> iterator = this.iterator(0L);
        while (iterator.hasNext()) {
            if (!element.equals(iterator.next())) continue;
            iterator.remove();
            this.map.remove(element);
            return true;
        }
        return false;
    }

    @Override
    public T get(Object o, long ts) {
        return this.map.get(o);
    }

    @Override
    public Iterator<T> iterator(long ts) {
        return new InternalIterator();
    }

    public Iterator<T> iterator() {
        return this.iterator(0L);
    }

    public T get(Object o) {
        return this.get(o, 0L);
    }

    private static class Node<T> {
        private final T content;
        private Node<T> next;

        private Node(T content) {
            this.content = content;
        }
    }

    public class InternalIterator
    extends AbstractGeneralAwareIterator<Node<T>, T>
    implements Iterator<T> {
        private Node<T> last;

        @Override
        protected void advance() {
            this.last = (Node)this.next;
            this.next = this.next == null ? DependenciesImpl.this.head : ((Node)this.next).next;
        }

        @Override
        public T project() {
            return ((Node)this.next).content;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            if (this.last == null) {
                DependenciesImpl.this.head = ((Node)this.next).next;
                return;
            }
            this.last.next = ((Node)this.next).next;
            if (((Node)this.next).next == null) {
                DependenciesImpl.this.tail = this.last;
            }
        }
    }
}

