/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.ExistsException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.exception.UnreachableOverridesException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.GenericHandler;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.SupersComputer;

public abstract class Context<T extends AbstractVertex<T>>
implements DefaultContext<T> {
    private final DefaultRoot<T> root;
    private final Checker<T> checker;
    protected Builder<T> builder;

    protected Context(DefaultRoot<T> root) {
        this.root = root;
        this.checker = this.buildChecker();
        this.builder = this.buildBuilder();
    }

    public abstract long getTs();

    protected Checker<T> buildChecker() {
        return new Checker(this);
    }

    protected abstract Builder<T> buildBuilder();

    public Checker<T> getChecker() {
        return this.checker;
    }

    public Builder<T> getBuilder() {
        return this.builder;
    }

    public DefaultRoot<T> getRoot() {
        return this.root;
    }

    public boolean isAlive(T vertex) {
        return vertex != null && vertex.equals(this.getAlive(vertex));
    }

    protected abstract T plug(T var1);

    protected abstract void unplug(T var1);

    public Set<T> computePotentialDependencies(T meta, List<T> supers, Serializable value, List<T> components) {
        return new PotentialDependenciesComputer((AbstractVertex)meta, supers, value, components){
            private static final long serialVersionUID = -3611136800445783634L;
            final /* synthetic */ AbstractVertex val$meta;
            final /* synthetic */ List val$supers;
            final /* synthetic */ Serializable val$value;
            final /* synthetic */ List val$components;
            {
                this.val$meta = abstractVertex;
                this.val$supers = list;
                this.val$value = serializable;
                this.val$components = list2;
            }

            @Override
            boolean isSelected(T node) {
                return node.isDependencyOf((DefaultVertex)this.val$meta, this.val$supers, this.val$value, this.val$components);
            }
        }.visit(meta);
    }

    private T getAlive(T vertex) {
        if (vertex.isRoot()) {
            return vertex;
        }
        if (vertex.isMeta()) {
            AbstractVertex aliveSuper = this.getAlive((AbstractVertex)((AbstractVertex)vertex).getSupers().get(0));
            return (T)(aliveSuper != null ? (AbstractVertex)this.getInheritings((T)aliveSuper).get(vertex) : null);
        }
        Object aliveMeta = this.getAlive(((AbstractVertex)vertex).getMeta());
        return (T)(aliveMeta != null ? (AbstractVertex)this.getInstances(aliveMeta).get(vertex) : null);
    }

    protected T getMeta(int dim) {
        AbstractVertex adjustedMeta = this.getBuilder().adjustMeta((AbstractVertex)this.getRoot(), dim);
        return (T)(adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null);
    }

    public abstract Snapshot<T> getInstances(T var1);

    public abstract Snapshot<T> getInheritings(T var1);

    public abstract Snapshot<T> getComposites(T var1);

    protected void triggersMutation(T oldDependency, T newDependency) {
    }

    public void forceRemove(T generic) {
        new GenericHandler<T>(generic).forceRemove();
    }

    public void remove(T generic) {
        new GenericHandler<T>(generic).remove();
    }

    public void conserveRemove(T generic) {
        new GenericHandler<T>(generic).conserveRemove();
    }

    @Deprecated
    public Set<T> computeDependencies(T node) {
        return this.computeDependencies(node, true);
    }

    Set<T> computeDependencies(T node, boolean force) {
        return new OrderedDependencies(force).visit(node);
    }

    protected static class AbstractVertexBuilder<T extends AbstractVertex<T>>
    extends Builder<T> {
        protected AbstractVertexBuilder(Context<T> context) {
            super(context);
        }

        @Override
        T rebuildAll(T toRebuild, Supplier<T> rebuilder, Set<T> dependenciesToRebuild) {
            dependenciesToRebuild.forEach(((Context)this.getContext())::unplug);
            if (rebuilder != null) {
                ConvertMap convertMap = new ConvertMap();
                dependenciesToRebuild.remove(toRebuild);
                AbstractVertex build = (AbstractVertex)rebuilder.get();
                if (toRebuild != null) {
                    convertMap.put(toRebuild, build);
                    this.getContext().triggersMutation(toRebuild, build);
                }
                Statics.reverseCollections(dependenciesToRebuild).forEach(x -> convertMap.convert(x));
                return (T)build;
            }
            return null;
        }

        public T setInstance(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
            GenericHandler<T> genericBuilder = new GenericHandler<T>(this, clazz, meta, overrides, value, components);
            T generic = genericBuilder.get();
            if (generic != null) {
                return generic;
            }
            generic = genericBuilder.getEquiv();
            return generic == null ? genericBuilder.add() : genericBuilder.set(generic);
        }

        public T update(T update, List<T> overrides, Serializable newValue, List<T> newComponents) {
            return new GenericHandler<T>(this, update.getClass(), ((AbstractVertex)update).getMeta(), overrides, newValue, newComponents).update(update);
        }

        public T addInstance(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
            GenericHandler<T> genericBuilder = new GenericHandler<T>(this, clazz, meta, overrides, value, components);
            T generic = genericBuilder.get();
            if (generic != null) {
                this.getContext().discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
            }
            return genericBuilder.add();
        }

        @Override
        List<T> computeAndCheckOverridesAreReached(T adjustedMeta, List<T> overrides, Serializable value, List<T> components) {
            ArrayList<T> supers = new ArrayList<T>(new SupersComputer<T>(adjustedMeta, overrides, value, components));
            if (!Statics.areOverridesReached(supers, overrides)) {
                this.getContext().discardWithException((Throwable)new UnreachableOverridesException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
            }
            return supers;
        }

        @Override
        protected T newT(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components) {
            return ((AbstractVertex)this.newT(clazz, meta)).init(meta, supers, value, components);
        }

        @Override
        protected T getOrBuild(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components) {
            T instance = meta == null ? this.getContext().getMeta(components.size()) : ((AbstractVertex)meta).getDirectInstance(value, components);
            return instance == null ? this.build(clazz, meta, supers, value, components) : instance;
        }

        private class ConvertMap
        extends HashMap<T, T> {
            private static final long serialVersionUID = 5003546962293036021L;

            private ConvertMap() {
            }

            private T convert(T oldDependency) {
                if (oldDependency.isAlive()) {
                    return oldDependency;
                }
                AbstractVertex newDependency = (AbstractVertex)this.get(oldDependency);
                if (newDependency == null) {
                    if (oldDependency.isMeta()) {
                        assert (((AbstractVertex)oldDependency).getSupers().size() == 1);
                        newDependency = AbstractVertexBuilder.this.setMeta(((AbstractVertex)oldDependency).getComponents().size());
                    } else {
                        List overrides = ((AbstractVertex)oldDependency).getSupers().stream().map(x -> this.convert(x)).collect(Collectors.toList());
                        for (int i = 0; i < overrides.size(); ++i) {
                            if (((AbstractVertex)overrides.get(i)).isAlive()) continue;
                            overrides.addAll(((AbstractVertex)overrides.get(i)).getSupers());
                            overrides.remove(i);
                        }
                        List components = ((AbstractVertex)oldDependency).getComponents().stream().map(x -> x != null ? (AbstractVertex)this.convert(x) : null).collect(Collectors.toList());
                        Object adjustedMeta = ((AbstractVertex)this.convert(((AbstractVertex)oldDependency).getMeta())).adjustMeta(((AbstractVertex)oldDependency).getValue(), components);
                        List supers = AbstractVertexBuilder.this.computeAndCheckOverridesAreReached(adjustedMeta, overrides, ((AbstractVertex)oldDependency).getValue(), components);
                        newDependency = AbstractVertexBuilder.this.getOrBuild(oldDependency.getClass(), adjustedMeta, supers, ((AbstractVertex)oldDependency).getValue(), components);
                    }
                    this.put((T)oldDependency, (T)newDependency);
                }
                return newDependency;
            }

            @Override
            public T put(T oldDependency, T newDependency) {
                AbstractVertex result = (AbstractVertex)super.put(oldDependency, newDependency);
                AbstractVertexBuilder.this.getContext().triggersMutation(oldDependency, newDependency);
                return result;
            }
        }
    }

    abstract class PotentialDependenciesComputer
    extends LinkedHashSet<T> {
        private static final long serialVersionUID = -5970021419012502402L;
        private final Set<T> alreadyVisited = new HashSet();

        PotentialDependenciesComputer() {
        }

        abstract boolean isSelected(T var1);

        PotentialDependenciesComputer visit(T node) {
            if (!this.alreadyVisited.contains(node)) {
                if (this.isSelected(node)) {
                    this.addDependency(node);
                } else {
                    this.alreadyVisited.add(node);
                    node.getComposites().forEach(this::visit);
                    node.getInheritings().forEach(this::visit);
                    node.getInstances().forEach(this::visit);
                }
            }
            return this;
        }

        private void addDependency(T node) {
            if (!this.alreadyVisited.contains(node)) {
                this.alreadyVisited.add(node);
                node.getComposites().forEach(this::addDependency);
                node.getInheritings().forEach(this::addDependency);
                node.getInstances().forEach(this::addDependency);
                super.add(node);
            }
        }
    }

    class OrderedDependencies
    extends LinkedHashSet<T> {
        private static final long serialVersionUID = -5970021419012502402L;
        private final boolean force;

        public OrderedDependencies(boolean force) {
            this.force = force;
        }

        OrderedDependencies visit(T node) {
            if (!this.contains(node)) {
                if (!this.force && !node.getInheritings().isEmpty()) {
                    Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a inheriting dependencies : " + node.getInheritings()));
                }
                Context.this.getInheritings(node).forEach(this::visit);
                if (!this.force && !node.getInstances().isEmpty()) {
                    Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a instance dependencies : " + node.getInstances()));
                }
                Context.this.getInstances(node).forEach(this::visit);
                for (AbstractVertex composite : node.getComposites()) {
                    if (!this.force) {
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (!((AbstractVertex)composite.getComponents().get(componentPos)).equals(node) || this.contains(composite) || !composite.getMeta().isReferentialIntegrityEnabled(componentPos)) continue;
                            Context.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + node + " by composite position : " + componentPos));
                        }
                    }
                    this.visit(composite);
                }
                this.add(node);
                for (int axe = 0; axe < ((AbstractVertex)node).getComponents().size(); ++axe) {
                    if (!node.isCascadeRemove(axe)) continue;
                    this.visit((AbstractVertex)((AbstractVertex)node).getComponents().get(axe));
                }
            }
            return this;
        }
    }
}

