/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.defaults.DefaultChecker;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.CollisionException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.CrossEnginesAssignementsException;
import org.genericsystem.api.exception.ExistsException;
import org.genericsystem.api.exception.MetaLevelConstraintViolationException;
import org.genericsystem.api.exception.MetaRuleConstraintViolationException;
import org.genericsystem.api.exception.NotAliveConstraintViolationException;
import org.genericsystem.api.exception.NotAllowedSerializableTypeException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.annotations.Priority;
import org.genericsystem.kernel.annotations.SystemGeneric;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public class Checker<T extends AbstractVertex<T>>
implements DefaultChecker<T> {
    private final Context<T> context;
    private final Comparator<T> CONSTRAINT_PRIORITY = new Comparator<T>(){

        @Override
        public int compare(T constraintHolder, T compareConstraintHolder) {
            return Checker.this.getConstraintPriority(((AbstractVertex)constraintHolder).getMeta()) < Checker.this.getConstraintPriority(((AbstractVertex)compareConstraintHolder).getMeta()) ? -1 : 1;
        }
    };

    public Checker(Context<T> context) {
        this.context = context;
    }

    public Context<T> getContext() {
        return this.context;
    }

    public void checkBeforeBuild(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) throws RollbackException {
        this.checkSystemConstraintsBeforeBuild(clazz, meta, overrides, value, components);
    }

    public void checkAfterBuild(boolean isOnAdd, boolean isFlushTime, T vertex) throws RollbackException {
        this.checkSystemConstraintsAfterBuild(isOnAdd, isFlushTime, vertex);
        this.checkConsistency(vertex);
        this.checkConstraints(isOnAdd, isFlushTime, vertex);
    }

    private void checkSystemConstraintsBeforeBuild(Class<?> clazz, T meta, List<T> overrides, Serializable value, List<T> components) {
        this.checkSameEngine(meta, overrides, components);
        this.checkIsAlive(meta, overrides, components);
        this.checkSerializableType(value);
        this.checkWellFormedMeta(meta, value, components);
    }

    private void checkSameEngine(T meta, List<T> overrides, List<T> components) {
        if (meta == null) {
            return;
        }
        DefaultRoot root = meta.getRoot();
        for (AbstractVertex component : components) {
            if (component == null || root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his component " + component + " because they are from differents engines"));
        }
        for (AbstractVertex directSuper : overrides) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkIsAlive(T meta, List<T> overrides, List<T> components) {
        if (meta != null) {
            this.checkIsAlive(meta);
        }
        overrides.forEach(x -> this.checkIsAlive(x));
        components.stream().filter(component -> component != null).forEach(x -> this.checkIsAlive(x));
    }

    private void checkSerializableType(Serializable value) {
        if (value == null) {
            return;
        }
        if (value instanceof AxedPropertyClass) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof Float) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Class) {
            return;
        }
        this.context.discardWithException((Throwable)new NotAllowedSerializableTypeException("Not allowed type for your serializable. Only primitive and Byte[] allowed."));
    }

    private void checkWellFormedMeta(T meta, Serializable value, List<T> components) {
        if (meta == null && (components.stream().anyMatch(x -> !x.isRoot()) || !Objects.equals(value, this.context.getRoot().getValue()))) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : (" + meta + ") " + value + " " + components));
        }
    }

    private void checkWellFormedMeta(T vertex) {
        if (vertex.isMeta() && (((AbstractVertex)vertex).getComponents().stream().anyMatch(c -> !c.isRoot()) || !Objects.equals(((AbstractVertex)vertex).getValue(), this.context.getRoot().getValue()) || ((AbstractVertex)vertex).getSupers().size() != 1 || !((AbstractVertex)((AbstractVertex)vertex).getSupers().get(0)).isMeta())) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : " + vertex.info()));
        }
    }

    protected void checkSystemConstraintsAfterBuild(boolean isOnAdd, boolean isFlushTime, T vertex) {
        this.checkWellFormedMeta(vertex);
        if (isOnAdd || !isFlushTime) {
            this.checkIsAlive(vertex);
        } else {
            this.checkIsNotAlive(vertex);
        }
        if (!isOnAdd) {
            this.checkDependenciesAreEmpty(vertex);
        }
        this.checkSameEngine(vertex);
        this.checkDependsMetaComponents(vertex);
        this.checkSupers(vertex);
        this.checkDependsSuperComponents(vertex);
        this.checkLevel(vertex);
        this.checkLevelComponents(vertex);
        this.checkSignatureUnicity(vertex);
        this.checkRemoveGenericAnnoted(isOnAdd, vertex);
    }

    private void checkRemoveGenericAnnoted(boolean isOnAdd, T vertex) {
        if (!isOnAdd && this.context.getBuilder().getAnnotedClass(vertex).getAnnotation(SystemGeneric.class) != null) {
            this.getContext().discardWithException(new IllegalAccessException("@SystemGeneric annoted generic can't be removed"));
        }
    }

    private void checkIsAlive(T vertex) {
        if (!this.context.isAlive(vertex)) {
            this.context.discardWithException((Throwable)new AliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkIsNotAlive(T vertex) {
        if (this.context.isAlive(vertex)) {
            this.context.discardWithException((Throwable)new NotAliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkDependenciesAreEmpty(T vertex) {
        if (!(this.context.getInstances(vertex).isEmpty() && this.context.getInheritings(vertex).isEmpty() && this.context.getComposites(vertex).isEmpty())) {
            this.context.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Unable to remove : " + vertex.info() + " cause it has dependencies"));
        }
    }

    private void checkSameEngine(T vertex) {
        DefaultRoot root = vertex.getRoot();
        for (AbstractVertex component : ((AbstractVertex)vertex).getComponents()) {
            if (component == null || root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his component " + component + " because they are from differents engines"));
        }
        for (AbstractVertex directSuper : ((AbstractVertex)vertex).getSupers()) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkDependsMetaComponents(T vertex) {
        if (((AbstractVertex)((AbstractVertex)vertex).getMeta()).getComponents().size() != ((AbstractVertex)vertex).getComponents().size()) {
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Added generic and its meta do not have the same components size. Added node components : " + ((AbstractVertex)vertex).getComponents() + " and meta components : " + ((AbstractVertex)((AbstractVertex)vertex).getMeta()).getComponents()));
        }
        for (int pos = 0; pos < ((AbstractVertex)vertex).getComponents().size(); ++pos) {
            AbstractVertex component = (AbstractVertex)vertex.getComponent(pos);
            AbstractVertex metaComponent = (AbstractVertex)((AbstractVertex)vertex).getMeta().getComponent(pos);
            if (component == null) {
                if (metaComponent == null) continue;
                component = vertex;
            } else if (metaComponent == null) {
                metaComponent = ((AbstractVertex)vertex).getMeta();
            }
            if (component.isInstanceOf(metaComponent) || component.inheritsFrom(metaComponent)) continue;
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Component of added generic : " + component + " must be instance of or must inherits from the component of its meta : " + metaComponent));
        }
    }

    private void checkSupers(T vertex) {
        if (!((AbstractVertex)vertex).getSupers().stream().allMatch(superVertex -> superVertex.getLevel() == vertex.getLevel())) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers (bad level) : " + ((AbstractVertex)vertex).getSupers()));
        }
        if (!((AbstractVertex)vertex).getSupers().stream().allMatch(superVertex -> vertex.getMeta().inheritsFrom(superVertex.getMeta()))) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers : " + ((AbstractVertex)vertex).getSupers()));
        }
        if (!((AbstractVertex)vertex).getSupers().stream().noneMatch(this::equals)) {
            this.context.discardWithException(new IllegalStateException("Supers loop detected : " + vertex.info()));
        }
        if (((AbstractVertex)vertex).getSupers().stream().anyMatch(superVertex -> Objects.equals(superVertex.getValue(), vertex.getValue()) && superVertex.getComponents().equals(vertex.getComponents()) && vertex.getMeta().inheritsFrom(superVertex.getMeta()))) {
            this.context.discardWithException((Throwable)new CollisionException("Collision detected : " + vertex.info() + " A collision occurs when two generics have same value and components and have same meta or metas that inherit one to another"));
        }
    }

    private void checkDependsSuperComponents(T vertex) {
        ((AbstractVertex)vertex).getSupers().forEach(superVertex -> {
            if (!superVertex.isSuperOf((DefaultVertex)vertex.getMeta(), vertex.getSupers(), vertex.getValue(), vertex.getComponents())) {
                this.context.discardWithException(new IllegalStateException("Inconsistant components : " + vertex.getComponents()));
            }
        });
    }

    private void checkLevel(T vertex) {
        if (vertex.getLevel() > 2) {
            this.context.discardWithException((Throwable)new MetaLevelConstraintViolationException("Unable to instanciate a concrete generic : " + ((AbstractVertex)vertex).getMeta()));
        }
    }

    private void checkLevelComponents(T vertex) {
        for (AbstractVertex component : ((AbstractVertex)vertex).getComponents()) {
            if ((component == null ? vertex.getLevel() : component.getLevel()) <= vertex.getLevel()) continue;
            this.context.discardWithException((Throwable)new MetaLevelConstraintViolationException("Inappropriate component meta level : " + component.getLevel() + " for component : " + component + ". Component meta level for added node is : " + vertex.getLevel()));
        }
    }

    private void checkSignatureUnicity(T vertex) {
        if (this.context.getInstances(((AbstractVertex)vertex).getMeta()).get().filter(x -> x.equalsRegardlessSupers((ISignature<?>)vertex.getMeta(), vertex.getValue(), vertex.getComponents())).count() > 1L) {
            this.context.discardWithException((Throwable)new ExistsException(vertex.info()));
        }
    }

    private void checkConstraints(boolean isOnAdd, boolean isFlushTime, T vertex) {
        AbstractVertex map = (AbstractVertex)this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null) {
            Stream<AbstractVertex> contraintsHolders = ((AbstractVertex)vertex).getMeta().getHolders((DefaultVertex)map).get().filter(holder -> ((AbstractVertex)holder.getMeta()).getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)((AbstractVertex)holder.getMeta()).getValue()).getClazz())).filter(holder -> holder.getValue() != null && !Boolean.FALSE.equals(holder.getValue())).sorted(this.CONSTRAINT_PRIORITY);
            contraintsHolders.forEach(constraintHolder -> {
                AbstractVertex targetComponent;
                AbstractVertex baseComponent = (AbstractVertex)constraintHolder.getBaseComponent();
                if (vertex.isSpecializationOf(baseComponent)) {
                    this.check(constraintHolder, baseComponent, isFlushTime, isOnAdd, false, vertex);
                }
                if ((targetComponent = (AbstractVertex)constraintHolder.getTargetComponent()) != null && vertex.isSpecializationOf(targetComponent)) {
                    this.check(constraintHolder, baseComponent, isFlushTime, isOnAdd, true, vertex);
                }
            });
        }
    }

    private void check(T constraintHolder, T baseComponent, boolean isFlushTime, boolean isOnAdd, boolean isRevert, T vertex) {
        try {
            this.statelessConstraint(((AbstractVertex)constraintHolder).getMeta()).check(vertex, baseComponent, ((AbstractVertex)constraintHolder).getValue(), ((AxedPropertyClass)((AbstractVertex)((AbstractVertex)constraintHolder).getMeta()).getValue()).getAxe(), isOnAdd, isFlushTime, isRevert);
        }
        catch (ConstraintViolationException e) {
            this.context.discardWithException(e);
        }
    }

    private Constraint<T> statelessConstraint(T vertex) {
        try {
            return (Constraint)((AxedPropertyClass)((AbstractVertex)vertex).getValue()).getClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.context.discardWithException(e);
            return null;
        }
    }

    private int getConstraintPriority(T vertex) {
        Class clazz = ((AxedPropertyClass)((AbstractVertex)vertex).getValue()).getClazz();
        Priority priority = clazz.getAnnotation(Priority.class);
        return priority != null ? priority.value() : 0;
    }

    private void checkConsistency(T vertex) {
        AbstractVertex map = (AbstractVertex)this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null && vertex.isInstanceOf((DefaultVertex)map) && ((AbstractVertex)((AbstractVertex)vertex).getMeta()).getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)((AbstractVertex)((AbstractVertex)vertex).getMeta()).getValue()).getClazz()) && ((AbstractVertex)vertex).getValue() != null && !Boolean.FALSE.equals(((AbstractVertex)vertex).getValue())) {
            AbstractVertex baseConstraint = (AbstractVertex)vertex.getComponent(0);
            int axe = ((AxedPropertyClass)((AbstractVertex)((AbstractVertex)vertex).getMeta()).getValue()).getAxe();
            if (((AxedPropertyClass)((AbstractVertex)((AbstractVertex)vertex).getMeta()).getValue()).getAxe() == -1) {
                baseConstraint.getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, false, x));
            } else {
                ((AbstractVertex)baseConstraint.getComponents().get(axe)).getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, true, x));
            }
        }
    }
}

