/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.genericsystem.api.defaults.DefaultBuilder;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Vertex;
import org.genericsystem.kernel.annotations.InstanceClass;

public abstract class Builder<T extends AbstractVertex<T>>
implements DefaultBuilder<T> {
    private final Context<T> context;

    protected Builder(Context<T> context) {
        this.context = context;
    }

    public Context<T> getContext() {
        return this.context;
    }

    protected Class<T> getTClass() {
        return Vertex.class;
    }

    protected Class<T> getSystemTClass() {
        return Vertex.SystemClass.class;
    }

    public final T[] newTArray(int dim) {
        return (AbstractVertex[])Array.newInstance(this.getTClass(), dim);
    }

    protected abstract T newT(Class<?> var1, T var2, List<T> var3, Serializable var4, List<T> var5);

    protected T newT(Class<?> clazz, T meta) {
        InstanceClass metaAnnotation;
        InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
        if (metaAnnotation != null) {
            if (clazz == null || clazz.isAssignableFrom(metaAnnotation.value())) {
                clazz = metaAnnotation.value();
            } else if (!metaAnnotation.value().isAssignableFrom(clazz)) {
                this.getContext().discardWithException((Throwable)new InstantiationException(clazz + " must extends " + metaAnnotation.value()));
            }
        }
        try {
            if (clazz == null) {
                return (T)((AbstractVertex)this.getTClass().newInstance());
            }
            if (!this.getTClass().isAssignableFrom(clazz)) {
                return (T)((AbstractVertex)this.getSystemTClass().newInstance());
            }
            return (T)((AbstractVertex)clazz.newInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            this.getContext().discardWithException((Throwable)e);
            return null;
        }
    }

    Class<?> getAnnotedClass(T vertex) {
        Class<?> vertexClass = vertex.getClass();
        if (vertexClass.equals(this.context.getBuilder().getSystemTClass())) {
            return this.context.getRoot().findAnnotedClass(vertex);
        }
        return vertexClass;
    }

    abstract T rebuildAll(T var1, Supplier<T> var2, Set<T> var3);

    T setMeta(int dim) {
        AbstractVertex root = (AbstractVertex)this.context.getRoot();
        AbstractVertex adjustedMeta = this.adjustMeta(root, dim);
        if (adjustedMeta.getComponents().size() == dim) {
            return (T)adjustedMeta;
        }
        Object[] components = this.newTArray(dim);
        Arrays.fill(components, root);
        return (T)this.rebuildAll(null, () -> this.lambda$setMeta$1(adjustedMeta, root, (AbstractVertex[])components), this.context.computePotentialDependencies(adjustedMeta, Collections.singletonList(adjustedMeta), root.getValue(), Arrays.asList(components)));
    }

    T adjustMeta(T meta, int dim) {
        assert (meta.isMeta());
        int size = ((AbstractVertex)meta).getComponents().size();
        if (size > dim) {
            return null;
        }
        if (size == dim) {
            return meta;
        }
        AbstractVertex directInheriting = (AbstractVertex)meta.getInheritings().first();
        return (T)(directInheriting != null && directInheriting.getComponents().size() <= dim ? this.adjustMeta(directInheriting, dim) : meta);
    }

    protected abstract T getOrBuild(Class<?> var1, T var2, List<T> var3, Serializable var4, List<T> var5);

    T build(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components) {
        return this.context.plug(this.newT(clazz, meta, supers, value, components));
    }

    abstract List<T> computeAndCheckOverridesAreReached(T var1, List<T> var2, Serializable var3, List<T> var4);

    private /* synthetic */ AbstractVertex lambda$setMeta$1(AbstractVertex abstractVertex, AbstractVertex abstractVertex2, AbstractVertex[] abstractVertexArray) {
        return this.build(null, null, Collections.singletonList(abstractVertex), abstractVertex2.getValue(), Arrays.asList(abstractVertexArray));
    }
}

