/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Archiver<T extends AbstractVertex<T>> {
    public static final Logger log = LoggerFactory.getLogger(Archiver.class);
    private static final long ARCHIVER_COEFF = 5L;
    private static final String PATTERN = "yyyy.MM.dd_HH-mm-ss.SSS";
    private static final String MATCHING_REGEX = "[0-9]{4}.[0-9]{2}.[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}.[0-9]{3}---[0-9]+";
    protected static final String GS_EXTENSION = ".gs";
    protected static final String ZIP_EXTENSION = ".zip";
    private static final String PART_EXTENSION = ".part";
    private static final String LOCK_FILE_NAME = ".lock";
    private static final long SNAPSHOTS_PERIOD = 1000L;
    private static final long SNAPSHOTS_INITIAL_DELAY = 1000L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    protected final DefaultRoot<T> root;
    private final File directory;
    private FileLock lockFile;
    private final ZipFileManager zipFileManager = new ZipFileManager(new FileManager());

    public static String getFileExtension() {
        return ".gs.zip";
    }

    protected Archiver(DefaultRoot<T> root, String directoryPath) {
        String snapshotPath;
        this.root = root;
        this.directory = this.prepareAndLockDirectory(directoryPath);
        if (this.directory != null && (snapshotPath = this.getSnapshotPath(this.directory)) != null) {
            try {
                this.getLoader(this.zipFileManager.getObjectInputStream(snapshotPath + Archiver.getFileExtension())).loadSnapshot();
            }
            catch (IOException | ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.startScheduler();
    }

    protected Loader getLoader(ObjectInputStream objectInputStream) {
        return new Loader(objectInputStream);
    }

    protected Saver getSaver(ObjectOutputStream objectOutputStream, long ts) {
        return new Saver(objectOutputStream, ts);
    }

    private Archiver<T> startScheduler() {
        if (this.directory != null && this.lockFile != null) {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        Archiver.this.doSnapshot();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public void close() {
        if (this.directory != null && this.lockFile != null) {
            this.scheduler.shutdown();
            try {
                this.doSnapshot();
                this.lockFile.close();
                this.lockFile = null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected long pickTs() {
        return 0L;
    }

    private void doSnapshot() throws IOException {
        long ts = this.pickTs();
        String fileName = Archiver.getFilename(ts);
        String partFileName = this.directory.getAbsolutePath() + File.separator + fileName + Archiver.getFileExtension() + PART_EXTENSION;
        ObjectOutputStream outputStream = this.zipFileManager.getObjectOutputStream(partFileName);
        this.getSaver(outputStream, ts).saveSnapshot(this.directory);
        new File(partFileName).renameTo(new File(this.directory.getAbsolutePath() + File.separator + fileName + Archiver.getFileExtension()));
        this.manageOldSnapshots(this.directory);
    }

    private void manageOldSnapshots(File directory) {
        long firstTs;
        NavigableMap<Long, File> snapshotsMap = Archiver.snapshotsMap(directory, Archiver.getFileExtension());
        long lastTs = (Long)snapshotsMap.lastKey();
        long ts = firstTs = ((Long)snapshotsMap.firstKey()).longValue();
        Iterator iterator = new TreeSet(snapshotsMap.keySet()).iterator();
        while (iterator.hasNext()) {
            long snapshotTs = (Long)iterator.next();
            if (snapshotTs == lastTs || snapshotTs == firstTs) continue;
            if (snapshotTs - ts < this.minInterval(lastTs - snapshotTs)) {
                this.removeSnapshot(snapshotsMap, snapshotTs);
                continue;
            }
            ts = snapshotTs;
        }
    }

    private long minInterval(long periodNumber) {
        return (long)Math.floor(periodNumber / 5L);
    }

    private void removeSnapshot(NavigableMap<Long, File> snapshotsMap, long ts) {
        ((File)snapshotsMap.get(ts)).delete();
        snapshotsMap.remove(ts);
    }

    private File prepareAndLockDirectory(String directoryPath) {
        if (directoryPath == null) {
            return null;
        }
        File directory = new File(directoryPath);
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException("Datasource path : " + directoryPath + " is not a directory");
            }
        } else if (!directory.mkdirs()) {
            throw new IllegalStateException("Can't make directory : " + directoryPath);
        }
        try {
            this.lockFile = new FileOutputStream(directoryPath + File.separator + LOCK_FILE_NAME).getChannel().tryLock();
            return directory;
        }
        catch (IOException | OverlappingFileLockException e) {
            throw new IllegalStateException("Locked directory : " + directoryPath);
        }
    }

    private String getSnapshotPath(File directory) {
        NavigableMap<Long, File> snapshotsMap = Archiver.snapshotsMap(directory, Archiver.getFileExtension());
        return snapshotsMap.isEmpty() ? null : directory.getAbsolutePath() + File.separator + Archiver.getFilename((Long)snapshotsMap.lastKey());
    }

    private static NavigableMap<Long, File> snapshotsMap(File directory, String extension) {
        TreeMap<Long, File> snapshotsMap = new TreeMap<Long, File>();
        for (File file : directory.listFiles()) {
            String filename = file.getName();
            if (file.isDirectory() || !filename.endsWith(extension) || !(filename = filename.substring(0, filename.length() - extension.length())).matches(MATCHING_REGEX)) continue;
            try {
                snapshotsMap.put(Archiver.getTimestamp(filename), file);
            }
            catch (ParseException pe) {
                throw new IllegalStateException(pe);
            }
        }
        return snapshotsMap;
    }

    private static long getTimestamp(String filename) throws ParseException {
        return Long.parseLong(filename.substring(filename.lastIndexOf("---") + 3));
    }

    private static String getFilename(long ts) {
        return new SimpleDateFormat(PATTERN).format(new Date(ts / 1000000L)) + "---" + ts;
    }

    protected static class FileManager {
        protected FileManager() {
        }

        protected FileOutputStream getFileOutputStream(String fileName) throws IOException {
            return new FileOutputStream(fileName);
        }

        protected FileInputStream getFileInputStream(String fileName) throws IOException {
            return new FileInputStream(new File(fileName));
        }
    }

    protected static class ZipFileManager {
        private final FileManager fileManager;

        protected ZipFileManager(FileManager fileManager) {
            this.fileManager = fileManager;
        }

        protected ObjectOutputStream getObjectOutputStream(String fileName) throws IOException {
            ZipOutputStream zipOutput = new ZipOutputStream(this.fileManager.getFileOutputStream(fileName));
            zipOutput.putNextEntry(new ZipEntry(fileName));
            return new ObjectOutputStream(zipOutput);
        }

        protected ObjectInputStream getObjectInputStream(String fileName) throws IOException {
            ZipInputStream inputStream = new ZipInputStream(this.fileManager.getFileInputStream(fileName));
            inputStream.getNextEntry();
            return new ObjectInputStream(inputStream);
        }
    }

    protected class Loader {
        protected final ObjectInputStream objectInputStream;
        protected final Transaction<T> transaction;

        protected Loader(ObjectInputStream objectInputStream) {
            this.objectInputStream = objectInputStream;
            this.transaction = this.buildTransaction();
        }

        protected Transaction<T> buildTransaction() {
            return new Transaction(Archiver.this.root, 0L);
        }

        public Transaction<T> getTransaction() {
            return this.transaction;
        }

        private void loadSnapshot() throws ClassNotFoundException, IOException {
            try {
                HashMap vertexMap = new HashMap();
                while (true) {
                    this.loadDependency(vertexMap);
                }
            }
            catch (EOFException eOFException) {
                return;
            }
        }

        protected long loadId() throws IOException {
            return this.objectInputStream.readLong();
        }

        protected Long[] loadOtherTs() throws IOException {
            return new Long[0];
        }

        protected void loadDependency(Map<Long, T> vertexMap) throws IOException, ClassNotFoundException {
            Long id = this.loadId();
            Long[] otherTs = this.loadOtherTs();
            Serializable value = (Serializable)this.objectInputStream.readObject();
            Object meta = this.loadAncestor(vertexMap);
            List supers = this.loadAncestors(vertexMap);
            List components = this.loadAncestors(vertexMap);
            vertexMap.put(id, this.getOrBuild(null, meta, supers, value, components, id, otherTs));
        }

        protected T getOrBuild(Class<?> clazz, T meta, List<T> supers, Serializable value, List<T> components, Long designTs, Long ... otherTs) {
            Object instance = meta == null ? this.transaction.getMeta(components.size()) : ((AbstractVertex)meta).getDirectInstance(value, components);
            return instance == null ? this.transaction.getBuilder().build(clazz, meta, supers, value, components) : instance;
        }

        protected List<T> loadAncestors(Map<Long, T> vertexMap) throws IOException {
            ArrayList ancestors = new ArrayList();
            int sizeComponents = this.objectInputStream.readInt();
            for (int j = 0; j < sizeComponents; ++j) {
                ancestors.add(this.loadAncestor(vertexMap));
            }
            return ancestors;
        }

        protected T loadAncestor(Map<Long, T> vertexMap) throws IOException {
            long designTs = this.objectInputStream.readLong();
            return (AbstractVertex)vertexMap.get(designTs);
        }
    }

    public class Saver {
        protected final ObjectOutputStream objectOutputStream;
        protected final Transaction<T> transaction;

        protected Saver(ObjectOutputStream objectOutputStream, long ts) {
            this.objectOutputStream = objectOutputStream;
            this.transaction = this.buildTransaction(ts);
        }

        protected Transaction<T> buildTransaction(long ts) {
            return new Transaction(Archiver.this.root, ts);
        }

        public Transaction<T> getTransaction() {
            return this.transaction;
        }

        private void saveSnapshot(File directory) throws IOException {
            this.writeDependencies(this.getOrderedVertices(), new HashSet());
            this.objectOutputStream.flush();
            this.objectOutputStream.close();
        }

        private void writeDependencies(List<T> dependencies, Set<T> vertexSet) throws IOException {
            for (AbstractVertex dependency : dependencies) {
                if (!vertexSet.add(dependency)) continue;
                this.writeDependency(dependency);
            }
        }

        private void writeDependency(T dependency) throws IOException {
            this.writeAncestorId(dependency);
            this.writeOtherTs(dependency);
            this.objectOutputStream.writeObject(((AbstractVertex)dependency).getValue());
            this.writeAncestorId(((AbstractVertex)dependency).getMeta());
            this.writeAncestorsId(((AbstractVertex)dependency).getSupers());
            this.writeAncestorsId(((AbstractVertex)dependency).getComponents());
        }

        protected void writeOtherTs(T dependency) throws IOException {
        }

        private void writeAncestorsId(List<T> ancestors) throws IOException {
            this.objectOutputStream.writeInt(ancestors.size());
            for (AbstractVertex ancestor : ancestors) {
                this.writeAncestorId(ancestor);
            }
        }

        protected void writeAncestorId(T ancestor) throws IOException {
            this.objectOutputStream.writeLong(System.identityHashCode(ancestor));
        }

        protected List<T> getOrderedVertices() {
            return Statics.reverseCollections(this.transaction.computeDependencies((AbstractVertex)Archiver.this.root));
        }
    }
}

