/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.systemproperty.constraints;

import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.DefaultVertex;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public class AliveConstraint
implements Constraint {
    @Override
    public <T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>> void check(DefaultVertex<T, U> modified, DefaultVertex<T, U> attribute) throws ConstraintViolationException {
        assert (modified.isAlive());
        for (DefaultVertex composite : modified.getComposites()) {
            if (composite.isAlive()) continue;
            throw new AliveConstraintViolationException("Composite : " + composite + " of added node " + modified + " should be alive.");
        }
        for (DefaultVertex directSuper : modified.getSupers()) {
            if (directSuper.isAlive()) continue;
            throw new AliveConstraintViolationException("Super : " + directSuper + " of added node " + modified + " should be alive.");
        }
    }
}

