/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Optional;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;
import org.genericsystem.kernel.systemproperty.CascadeRemoveProperty;
import org.genericsystem.kernel.systemproperty.NoReferentialIntegrityProperty;
import org.genericsystem.kernel.systemproperty.constraints.PropertyConstraint;
import org.genericsystem.kernel.systemproperty.constraints.RequiredConstraint;
import org.genericsystem.kernel.systemproperty.constraints.SingularConstraint;

public interface DefaultSystemProperties<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends IVertex<T, U> {
    default public Serializable getSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        Optional result;
        Optional key = ((AbstractVertex)this).getKey(new AxedPropertyClass(propertyClass, pos));
        if (key.isPresent() && (result = this.getValues((IVertex)key.get()).stream().findFirst()).isPresent()) {
            return (Serializable)result.get();
        }
        return null;
    }

    default public T setSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos, Serializable value) {
        Object map = ((AbstractVertex)this).getMap();
        ((AbstractVertex)map).getMeta().setInstance(map, (Serializable)new AxedPropertyClass(propertyClass, pos), (AbstractVertex[])this.coerceToTArray(new Object[]{this.getRoot()})).setInstance(value, (AbstractVertex[])this.coerceToTArray(new Object[]{this}));
        return (T)((AbstractVertex)this);
    }

    default public T enableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        this.setSystemPropertyValue((Class)propertyClass, pos, (Serializable)Boolean.TRUE);
        return (T)((AbstractVertex)this);
    }

    default public T disableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        this.setSystemPropertyValue((Class)propertyClass, pos, (Serializable)Boolean.FALSE);
        return (T)((AbstractVertex)this);
    }

    default public boolean isSystemPropertyEnabled(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    default public T enableReferentialIntegrity(int pos) {
        return (T)this.disableSystemProperty(NoReferentialIntegrityProperty.class, pos);
    }

    default public T disableReferentialIntegrity(int pos) {
        return (T)this.enableSystemProperty(NoReferentialIntegrityProperty.class, pos);
    }

    default public boolean isReferentialIntegrityEnabled(int pos) {
        return !this.isSystemPropertyEnabled(NoReferentialIntegrityProperty.class, pos);
    }

    default public T enableSingularConstraint(int pos) {
        return (T)this.enableSystemProperty(SingularConstraint.class, pos);
    }

    default public T disableSingularConstraint(int pos) {
        return (T)this.disableSystemProperty(SingularConstraint.class, pos);
    }

    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    default public T enablePropertyConstraint() {
        return (T)this.enableSystemProperty(PropertyConstraint.class, -1);
    }

    default public T disablePropertyConstraint() {
        return (T)this.disableSystemProperty(PropertyConstraint.class, -1);
    }

    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    default public T enableRequiredConstraint(int pos) {
        return (T)this.enableSystemProperty(RequiredConstraint.class, pos);
    }

    default public T disableRequiredConstraint(int pos) {
        return (T)this.disableSystemProperty(RequiredConstraint.class, pos);
    }

    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    default public T enableCascadeRemove(int pos) {
        return (T)this.enableSystemProperty(CascadeRemoveProperty.class, pos);
    }

    default public T disableCascadeRemove(int pos) {
        return (T)this.disableSystemProperty(CascadeRemoveProperty.class, pos);
    }

    default public boolean isCascadeRemove(int pos) {
        return this.isSystemPropertyEnabled(CascadeRemoveProperty.class, pos);
    }
}

