/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.Statics;

public interface DefaultDisplay<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends IVertex<T, U> {
    default public String info() {
        return "(" + ((AbstractVertex)this.getMeta()).getValue() + ")" + this.getSupers() + this + this.getComposites() + " ";
    }

    default public String detailedInfo() {
        String s = "\n\n*******************************" + System.identityHashCode(this) + "******************************\n";
        s = s + " Value       : " + this.getValue() + "\n";
        s = s + " Meta        : " + this.getMeta() + " (" + System.identityHashCode(this.getMeta()) + ")\n";
        s = s + " MetaLevel   : " + Statics.getMetaLevelString(this.getLevel()) + "\n";
        s = s + " Category    : " + Statics.getCategoryString(this.getLevel(), this.getComposites().size()) + "\n";
        s = s + " Class       : " + this.getClass().getName() + "\n";
        s = s + "**********************************************************************\n";
        for (AbstractVertex superGeneric : this.getSupers()) {
            s = s + " Super       : " + superGeneric + " (" + System.identityHashCode(superGeneric) + ")\n";
        }
        for (AbstractVertex component : this.getComposites()) {
            s = s + " Component   : " + component + " (" + System.identityHashCode(component) + ")\n";
        }
        s = s + "**********************************************************************\n";
        return s;
    }

    default public String toPrettyString() {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = Json.createWriterFactory((Map)new HashMap<String, JsonValue>(){
            private static final long serialVersionUID = -8719498570554805477L;
            {
                this.put("javax.json.stream.JsonGenerator.prettyPrinting", JsonValue.TRUE);
            }
        }).createWriter((Writer)writer);
        jsonWriter.write((JsonStructure)this.toPrettyJSon());
        jsonWriter.close();
        return writer.toString();
    }

    default public JsonObject toPrettyJSon() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Value", this.toString());
        for (AbstractVertex attribute : this.getAttributes()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (AbstractVertex holder : this.getHolders(attribute)) {
                if (((AbstractVertex)holder.getComposites().get(0)).isSpecializationOf((AbstractVertex)this)) {
                    arrayBuilder.add((JsonValue)holder.toPrettyJSon());
                }
                builder.add(attribute.toString(), arrayBuilder);
            }
        }
        return builder.build();
    }

    default public JsonObject toJSonId() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Id", System.identityHashCode(this));
        builder.add("Value", this.toString());
        builder.add("Meta", System.identityHashCode(this.getMeta()));
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (AbstractVertex superVertex : this.getSupers()) {
            arrayBuilder.add(System.identityHashCode(superVertex));
        }
        builder.add("Supers", arrayBuilder);
        for (AbstractVertex component : this.getComposites()) {
            arrayBuilder.add(System.identityHashCode(component));
        }
        builder.add("Components", arrayBuilder);
        return builder.build();
    }
}

