/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.systemproperty.constraints;

import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.PropertyConstraintViolationException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.DefaultVertex;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public class PropertyConstraint
implements Constraint {
    @Override
    public <T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>> void check(DefaultVertex<T, U> modified, DefaultVertex<T, U> attribute) throws ConstraintViolationException {
        if (attribute.getValue().equals(AbstractVertex.SystemMap.class)) {
            return;
        }
        AbstractVertex base = (AbstractVertex)modified.getComposites().get(0);
        Stream<AbstractVertex> snapshot = base.getHolders((AbstractVertex)attribute).stream().filter(x -> ((AbstractVertex)x.getComposites().get(0)).equals(base)).filter(next -> {
            for (int compositePos = 1; compositePos < next.getComposites().size(); ++compositePos) {
                if (Objects.equals(next.getComposites().get(compositePos), modified.getComposites().get(compositePos))) continue;
                return false;
            }
            return true;
        });
        if (snapshot.count() > 1L) {
            throw new PropertyConstraintViolationException(modified + " has more than one " + attribute);
        }
    }

    @Override
    public <T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>> boolean isCheckedAt(DefaultVertex<T, U> modified, Constraint.CheckingType checkingType) {
        return checkingType.equals((Object)Constraint.CheckingType.CHECK_ON_ADD) || modified.getValue() == null && checkingType.equals((Object)Constraint.CheckingType.CHECK_ON_REMOVE);
    }
}

