/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractGeneralAwareIterator<D, T>
implements Iterator<T> {
    public D next = null;
    protected boolean toRead = true;

    @Override
    public boolean hasNext() {
        this.advanceIfNeeded();
        return this.next != null;
    }

    @Override
    public T next() {
        this.advanceIfNeeded();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T content = this.project();
        this.toRead = true;
        return content;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advanceIfNeeded() {
        if (this.toRead) {
            this.advance();
            this.toRead = false;
        }
    }

    protected abstract void advance();

    protected abstract T project();
}

