/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.Statics;

class InheritanceComputer<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends HashSet<T> {
    private static final long serialVersionUID = 1877502935577170921L;
    private final Map<T, Collection<T>> inheritings = new HashMap<T, Collection<T>>();
    private final T base;
    private final T origin;
    private final int level;

    public InheritanceComputer(T base, T origin, int level) {
        this.base = base;
        this.origin = origin;
        this.level = level;
    }

    Iterator<T> inheritanceIterator() {
        return this.getInheringsStream(this.base).iterator();
    }

    private Stream<T> getInheringsStream(T superVertex) {
        Collection result = this.inheritings.get(superVertex);
        if (result == null) {
            result = new Inheritings(this, (AbstractVertex)superVertex).inheritanceStream().collect(Collectors.toList());
            this.inheritings.put(superVertex, result);
        }
        return result.stream();
    }

    private static class Inheritings {
        private final T localBase;
        final /* synthetic */ InheritanceComputer this$0;

        private Inheritings(T localBase) {
            this.this$0 = var1_1;
            this.localBase = localBase;
        }

        private boolean isTerminal() {
            return this.localBase.equals(this.this$0.base);
        }

        protected Stream<T> inheritanceStream() {
            return this.projectStream(this.fromAboveStream());
        }

        private Stream<T> baseSupersStream() {
            return ((AbstractVertex)this.localBase).getSupers().stream().filter(next -> this.this$0.origin.isComponentOf(next));
        }

        private Stream<T> fromAboveStream() {
            if (!this.this$0.origin.isComponentOf(this.localBase)) {
                return Stream.empty();
            }
            if (this.baseSupersStream().count() == 0L) {
                return this.localBase.isRoot() || !this.this$0.origin.isComponentOf(((AbstractVertex)this.localBase).getMeta()) ? Stream.of(this.this$0.origin) : this.this$0.getInheringsStream(((AbstractVertex)this.localBase).getMeta());
            }
            return Statics.concat(this.baseSupersStream(), superVertex -> this.this$0.getInheringsStream(superVertex)).distinct();
        }

        private Stream<T> projectStream(Stream<T> streamToProject) {
            return Statics.concat(streamToProject, holder -> this.getStream(holder)).distinct();
        }

        private Stream<T> getStream(T holder) {
            if (((AbstractVertex)holder).getLevel() != this.this$0.level || ((AbstractVertex)this.localBase).getSuperComponents(holder).iterator().hasNext()) {
                this.this$0.add(holder);
            }
            Stream indexStream = Stream.concat(((AbstractVertex)holder).getLevel() < this.this$0.level ? ((AbstractVertex)this.localBase).getMetaComponents(holder).stream() : Stream.empty(), ((AbstractVertex)this.localBase).getSuperComponents(holder).stream());
            return Stream.concat(this.isTerminal() && this.this$0.contains(holder) ? Stream.empty() : Stream.of(holder), this.projectStream(indexStream));
        }
    }
}

