/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;

abstract class DependenciesComputer<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -5970021419012502402L;
    private final Set<T> alreadyVisited = new HashSet<T>();

    DependenciesComputer() {
    }

    abstract boolean checkDependency(T var1);

    DependenciesComputer<T, U> visit(T node) {
        if (!this.alreadyVisited.contains(node)) {
            if (this.checkDependency(node)) {
                this.addDependency(node);
            } else {
                this.alreadyVisited.add(node);
                ((AbstractVertex)node).getComponents().forEach(this::visit);
                ((AbstractVertex)node).getInheritings().forEach(this::visit);
                ((AbstractVertex)node).getInstances().forEach(this::visit);
            }
        }
        return this;
    }

    private void addDependency(T node) {
        if (!this.alreadyVisited.contains(node)) {
            this.alreadyVisited.add(node);
            ((AbstractVertex)node).getComponents().forEach(this::addDependency);
            ((AbstractVertex)node).getInheritings().forEach(this::addDependency);
            ((AbstractVertex)node).getInstances().forEach(this::addDependency);
            super.add(node);
        }
    }
}

