/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;

public interface DefaultDependencies<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends IVertex<T, U> {
    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isRoot() && this.isAncestorOf(((AbstractVertex)dependency).getMeta()) || ((AbstractVertex)dependency).getSupers().stream().anyMatch(this::isAncestorOf) || ((AbstractVertex)dependency).getComposites().stream().filter(composite -> !dependency.equals(composite)).anyMatch(this::isAncestorOf);
    }

    default public Snapshot<T> getAllInheritings() {
        return () -> Stream.concat(Stream.of((AbstractVertex)this), this.getInheritings().stream().flatMap(inheriting -> inheriting.getAllInheritings().stream())).distinct().iterator();
    }

    default public Snapshot<T> getAllInstances() {
        return () -> this.getAllInheritings().stream().flatMap(inheriting -> inheriting.getInstances().stream()).iterator();
    }

    default public T addInstance(List<T> overrides, Serializable value, T ... composites) {
        return ((AbstractVertex)this).bindInstance(null, true, overrides, value, Arrays.asList(composites));
    }

    default public T setInstance(List<T> overrides, Serializable value, T ... composites) {
        return ((AbstractVertex)this).bindInstance(null, false, overrides, value, Arrays.asList(composites));
    }

    default public T getInstance(T superT, Serializable value, T ... components) {
        return (T)this.getInstance(Collections.singletonList(superT), value, (AbstractVertex[])components);
    }

    default public T getInstance(Serializable value, T ... components) {
        return (T)this.getInstance(Collections.emptyList(), value, (AbstractVertex[])components);
    }

    default public T getInstance(List<T> overrides, Serializable value, T ... composites) {
        T adjustedMeta = ((AbstractVertex)this).adjustMeta(value, Arrays.asList(composites));
        return ((AbstractVertex)adjustedMeta).getDirectInstance(overrides, value, Arrays.asList(composites));
    }

    default public Optional<T> getInstanceInAll(List<T> overrides, Serializable value, T ... composites) {
        Stream<AbstractVertex> adjustedMetas = Stream.of((AbstractVertex)this).flatMap(meta -> meta.getInheritings().stream().filter(inheriting -> ((AbstractVertex)this).isAdjusted(inheriting, value, Arrays.asList(composites))));
        return adjustedMetas.map(adjustedMeta -> adjustedMeta.getDirectInstance(overrides, value, Arrays.asList(composites))).findFirst();
    }
}

