/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;

public class SupersComputer<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -1078004898524170057L;
    private final int level;
    private final T meta;
    private final List<T> overrides;
    private final List<T> composites;
    private final Serializable value;
    private final Map<T, Boolean> alreadyComputed = new HashMap<T, Boolean>();

    public SupersComputer(int level, T meta, List<T> overrides, Serializable value, List<T> composites) {
        this.level = level;
        this.meta = meta;
        this.overrides = overrides;
        this.composites = composites;
        this.value = value;
        this.visit((AbstractVertex)meta.getRoot());
    }

    private boolean visit(T candidate) {
        boolean isSuper;
        Boolean result = this.alreadyComputed.get(candidate);
        if (result != null) {
            return result;
        }
        boolean isMeta = this.meta.isSpecializationOf(candidate);
        boolean bl = isSuper = !isMeta && ((AbstractVertex)candidate).isSuperOf(this.meta, this.overrides, this.value, this.composites);
        if (!isMeta && !isSuper) {
            this.alreadyComputed.put(candidate, false);
            return false;
        }
        boolean selectable = true;
        for (AbstractVertex inheriting : ((AbstractVertex)candidate).getInheritings()) {
            if (!this.visit(inheriting)) continue;
            selectable = false;
        }
        if (isMeta) {
            for (AbstractVertex instance : ((AbstractVertex)candidate).getInstances()) {
                if (!this.visit(instance)) continue;
                selectable = false;
            }
        }
        result = this.alreadyComputed.put(candidate, selectable);
        assert (result == null) : candidate.info();
        if (selectable && ((AbstractVertex)candidate).getLevel() == this.level && !((AbstractVertex)candidate).equals((ISignature<?>)this.meta, (List<? extends ISignature<?>>)this.overrides, this.value, (List<? extends ISignature<?>>)this.composites)) {
            this.add(candidate);
        }
        return selectable;
    }
}

