/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.kernel.AbstractVertex;

public class SignatureImpl<T extends AbstractVertex<T, ?>>
implements Supplier<T> {
    private final SignatureImpl<T> metaSignature;
    private List<Serializable> superValues;
    private Serializable value;
    private List<Serializable> compositeValues;

    public SignatureImpl(SignatureImpl<T> metaSignature) {
        this.metaSignature = metaSignature;
    }

    public Serializable getMetaValue() {
        return this.metaSignature.getValue();
    }

    public List<Serializable> getSuperValues() {
        return this.superValues;
    }

    public void setSuperValues(List<Serializable> superValues) {
        this.superValues = superValues;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public List<Serializable> getCompositeValues() {
        return this.compositeValues;
    }

    public void setCompositeValues(List<Serializable> compositeValues) {
        this.compositeValues = compositeValues;
    }

    @Override
    public T get() {
        Object meta = this.metaSignature.get();
        for (AbstractVertex instance : ((AbstractVertex)meta).getInstances()) {
            if (!Objects.equals(this.value, instance.getValue()) || !this.compositeValues.equals(instance.getComposites().stream().map(composite -> composite.getValue()).collect(Collectors.toList()))) continue;
            return (T)instance;
        }
        return null;
    }
}

