/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;

public interface DefaultWritable<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends IVertex<T, U> {
    default public T updateValue(Serializable newValue) {
        return (T)this.update(this.getSupers(), newValue, (AbstractVertex[])this.coerceToTArray(this.getComposites().toArray()));
    }

    default public T updateSupers(T ... supersToAdd) {
        return (T)this.update(Arrays.asList(supersToAdd), this.getValue(), (AbstractVertex[])this.coerceToTArray(this.getComposites().toArray()));
    }

    default public T updateComponents(T ... newComponents) {
        return (T)this.update(this.getSupers(), this.getValue(), (AbstractVertex[])newComponents);
    }

    default public T update(List<T> supersToAdd, Serializable newValue, T ... newComponents) {
        return ((AbstractVertex)this).update(supersToAdd, newValue, Arrays.asList(newComponents));
    }

    default public T update(Serializable newValue, T ... newComponents) {
        return (T)this.update(Collections.emptyList(), newValue, (AbstractVertex[])newComponents);
    }

    default public T setInstance(Serializable value, T ... composites) {
        return (T)((AbstractVertex)this.setInstance(Collections.emptyList(), value, (IVertex[])composites));
    }

    default public T setInstance(T override, Serializable value, T ... composites) {
        return (T)((AbstractVertex)this.setInstance(Collections.singletonList(override), value, (IVertex[])composites));
    }

    default public T addInstance(Serializable value, T ... composites) {
        return (T)((AbstractVertex)this.addInstance(Collections.emptyList(), value, (IVertex[])composites));
    }

    default public T addInstance(T override, Serializable value, T ... composites) {
        return (T)((AbstractVertex)this.addInstance(Collections.singletonList(override), value, (IVertex[])composites));
    }

    default public T addAttribute(Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.emptyList(), value, (AbstractVertex[])targets);
    }

    default public T setAttribute(Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.emptyList(), value, (AbstractVertex[])targets);
    }

    default public T addHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.addInstance(value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T setHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.setInstance(value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T addAttribute(T override, Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.singletonList(override), value, (AbstractVertex[])targets);
    }

    default public T setAttribute(T override, Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.singletonList(override), value, (AbstractVertex[])targets);
    }

    default public T addHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.addInstance(override, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T setHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.setInstance(override, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T addAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)((DefaultRoot)this.getRoot()).addInstance(overrides, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T setAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)((DefaultRoot)this.getRoot()).setInstance(overrides, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T addHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.addInstance(overrides, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }

    default public T setHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.setInstance(overrides, value, (AbstractVertex[])this.addThisToTargets((IVertex[])targets));
    }
}

