/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Objects;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.DefaultRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DefaultAncestors<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
extends IVertex<T, U> {
    public static final Logger log = LoggerFactory.getLogger(DefaultAncestors.class);

    default public boolean isRoot() {
        return false;
    }

    default public boolean isAlive() {
        return this.equals(this.getAlive());
    }

    default public void checkIsAlive() {
        if (!this.equals(this.getAlive())) {
            this.getRoot().discardWithException((Throwable)new AliveConstraintViolationException(this.info()));
        }
    }

    default public T getAlive() {
        IVertex aliveMeta = ((AbstractVertex)this.getMeta()).getAlive();
        if (aliveMeta != null) {
            for (AbstractVertex instance : aliveMeta.getInstances()) {
                if (!this.equals(instance)) continue;
                return (T)instance;
            }
        }
        return null;
    }

    default public boolean equiv(IVertex<?, ?> service) {
        return this.equals(service) || ((AbstractVertex)this).equiv((IVertex)service.getMeta(), service.getValue(), service.getComposites());
    }

    default public int getLevel() {
        return this.isRoot() || Objects.equals(this.getValue(), this.getRoot().getValue()) || this.getComposites().stream().allMatch(c -> c.isRoot()) ? 0 : ((AbstractVertex)this.getMeta()).getLevel() + 1;
    }

    default public U getRoot() {
        return (U)((AbstractVertex)this.getMeta()).getRoot();
    }

    default public boolean isMeta() {
        return this.getLevel() == 0;
    }

    default public boolean isStructural() {
        return this.getLevel() == 1;
    }

    default public boolean isConcrete() {
        return this.getLevel() == 2;
    }

    default public boolean inheritsFrom(T superVertex) {
        if (this.equals(superVertex)) {
            return true;
        }
        if (this.getLevel() != ((AbstractVertex)superVertex).getLevel()) {
            return false;
        }
        return this.getSupers().stream().anyMatch(vertex -> vertex.inheritsFrom(superVertex));
    }

    default public boolean isInstanceOf(T metaVertex) {
        return ((AbstractVertex)this.getMeta()).inheritsFrom(metaVertex);
    }

    default public boolean isSpecializationOf(T supra) {
        return this.getLevel() == ((AbstractVertex)supra).getLevel() ? this.inheritsFrom(supra) : this.getLevel() > ((AbstractVertex)supra).getLevel() && ((AbstractVertex)this.getMeta()).isSpecializationOf(supra);
    }

    default public boolean isComponentOf(T vertex) {
        return this.isRoot() || this.getComposites().stream().anyMatch(composite -> vertex.isSpecializationOf((Object)composite));
    }
}

