/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.AmbiguousSelectionException;
import org.genericsystem.api.exception.ConsistencyConstraintViolationException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.CrossEnginesAssignementsException;
import org.genericsystem.api.exception.ExistsException;
import org.genericsystem.api.exception.NotFoundException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.kernel.DefaultAncestors;
import org.genericsystem.kernel.DefaultRoot;
import org.genericsystem.kernel.DefaultVertex;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.DependenciesComputer;
import org.genericsystem.kernel.DependenciesImpl;
import org.genericsystem.kernel.InheritanceComputer;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.SupersComputer;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public abstract class AbstractVertex<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
implements DefaultVertex<T, U> {
    private T meta;
    private List<T> composites;
    private Serializable value;
    private boolean throwExistException;
    protected List<T> supers;
    private final Function<? super ISignature<?>, ? extends IVertex<?, ?>> NULL_TO_THIS = x -> x == null ? this : (IVertex)x;
    private final Comparator<T> priorityConstraintComparator = new Comparator<T>(){

        @Override
        public int compare(T constraintHolder, T compareConstraintHolder) {
            return Constraint.getPriorityOf(((AxedPropertyClass)((AbstractVertex)constraintHolder).getValue()).getClazz()) < Constraint.getPriorityOf(((AxedPropertyClass)((AbstractVertex)compareConstraintHolder).getValue()).getClazz()) ? -1 : 1;
        }
    };

    protected T init(boolean throwExistException, T meta, Serializable value, List<T> composites) {
        this.throwExistException = throwExistException;
        if (meta != null) {
            meta.checkIsAlive();
            this.meta = meta;
        } else {
            this.meta = this;
        }
        this.value = value;
        this.composites = new ArrayList<T>(composites);
        for (int i = 0; i < composites.size(); ++i) {
            AbstractVertex composite = (AbstractVertex)composites.get(i);
            if (composite != null) {
                composite.checkIsAlive();
                this.composites.set(i, composite);
                continue;
            }
            this.composites.set(i, this);
        }
        return (T)this;
    }

    public boolean isThrowExistException() {
        return this.throwExistException;
    }

    public T getMeta() {
        return this.meta;
    }

    public List<T> getComposites() {
        return this.composites;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }

    @Override
    public int getLevel() {
        return this.isRoot() || this.composites.stream().allMatch(c -> c.isRoot()) && Objects.equals(this.getValue(), this.getRoot().getValue()) ? 0 : ((AbstractVertex)this.meta).getLevel() + 1;
    }

    protected abstract Dependencies<T> getInstancesDependencies();

    protected abstract Dependencies<T> getInheritingsDependencies();

    protected abstract Dependencies<Dependencies.DependenciesEntry<T>> getMetaComponentsDependencies();

    protected abstract Dependencies<Dependencies.DependenciesEntry<T>> getSuperComponentsDependencies();

    protected T init(boolean throwExistException, T meta, List<T> supers, Serializable value, List<T> components) {
        this.init(throwExistException, meta, value, components);
        this.supers = supers;
        return (T)this;
    }

    protected T newT(Class<?> clazz, boolean throwExistException, T meta, List<T> supers, Serializable value, List<T> components) {
        return ((AbstractVertex)this.newT(clazz)).init(throwExistException, meta, supers, value, components);
    }

    protected T newT(Class<?> clazz) {
        return this.newT();
    }

    public List<T> getSupers() {
        return this.supers;
    }

    protected <H> Dependencies<H> buildDependencies() {
        return new DependenciesImpl();
    }

    protected void forceRemove() {
        this.computeDependencies().forEach(this::simpleRemove);
    }

    private void simpleRemove(T vertex) {
        if (!vertex.isAlive()) {
            this.getRoot().discardWithException((Throwable)new AliveConstraintViolationException(vertex.info() + " is not alive"));
        }
        if (!(((AbstractVertex)vertex).getInstances().isEmpty() && ((AbstractVertex)vertex).getInheritings().isEmpty() && ((AbstractVertex)vertex).getComponents().isEmpty())) {
            this.getRoot().discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException(vertex.info() + " has dependencies"));
        }
        ((AbstractVertex)vertex).unplug();
    }

    private Iterable<T> reverseLinkedHashSet(LinkedHashSet<T> linkedHashSet) {
        ArrayList<T> dependencies = new ArrayList<T>(linkedHashSet);
        Collections.reverse(dependencies);
        return dependencies;
    }

    private Iterable<T> getOrderedDependenciesToRemove() {
        return this.reverseLinkedHashSet(this.buildOrderedDependenciesToRemove());
    }

    public void remove() {
        this.getOrderedDependenciesToRemove().forEach(x -> this.simpleRemove(x));
    }

    final T update(List<T> supersToAdd, Serializable newValue, List<T> newComposites) {
        if (newComposites.size() != this.getComposites().size()) {
            this.getRoot().discardWithException(new IllegalArgumentException());
        }
        return (T)this.rebuildAll(() -> ((AbstractVertex)this.getMeta()).bindInstance(null, this.isThrowExistException(), new Statics.Supers(this.getSupers(), supersToAdd), newValue, newComposites), this.computeDependencies());
    }

    protected LinkedHashSet<T> computeDependencies() {
        return new DependenciesComputer<T, U>(){
            private static final long serialVersionUID = 4116681784718071815L;

            @Override
            boolean checkDependency(T node) {
                return AbstractVertex.this.isAncestorOf((AbstractVertex)node);
            }
        }.visit(this.getMeta());
    }

    private LinkedHashSet<T> buildOrderedDependenciesToRemove() {
        return new LinkedHashSet<T>(){
            private static final long serialVersionUID = -3610035019789480505L;
            {
                this.visit(AbstractVertex.this);
            }

            public void visit(T generic) {
                if (this.add(generic)) {
                    if (!((AbstractVertex)generic).getInheritings().isEmpty() || !((AbstractVertex)generic).getInstances().isEmpty()) {
                        AbstractVertex.this.getRoot().discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + generic + " has an inheritance or instance dependency"));
                    }
                    for (AbstractVertex component : ((AbstractVertex)generic).getComponents()) {
                        if (generic.equals(component)) continue;
                        for (int compositePos = 0; compositePos < component.getComposites().size(); ++compositePos) {
                            if (!((AbstractVertex)component.getComposites().get(compositePos)).equals(generic) || this.contains(component) || !component.isReferentialIntegrityEnabled(compositePos)) continue;
                            AbstractVertex.this.getRoot().discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException(component + " is Referential Integrity for ancestor " + generic + " by component position : " + compositePos));
                        }
                        this.visit(component);
                    }
                    for (int axe = 0; axe < ((AbstractVertex)generic).getComposites().size(); ++axe) {
                        if (!generic.isCascadeRemove(axe)) continue;
                        this.visit((AbstractVertex)((AbstractVertex)generic).getComposites().get(axe));
                    }
                }
            }
        };
    }

    protected LinkedHashSet<T> computePotentialDependencies(final List<T> overrides, final Serializable value, final List<T> composites) {
        return new DependenciesComputer<T, U>(){
            private static final long serialVersionUID = -3611136800445783634L;

            @Override
            boolean checkDependency(T node) {
                return node.dependsFrom((AbstractVertex)AbstractVertex.this, overrides, value, composites);
            }
        }.visit(this);
    }

    public T adjustMeta(Serializable value, T ... composites) {
        return this.adjustMeta(value, Arrays.asList(composites));
    }

    T adjustMeta(Serializable value, List<T> composites) {
        AbstractVertex result = null;
        for (AbstractVertex directInheriting : this.getInheritings()) {
            if (!this.isAdjusted(directInheriting, value, composites)) continue;
            if (result == null) {
                result = directInheriting;
                continue;
            }
            this.getRoot().discardWithException((Throwable)new AmbiguousSelectionException("Ambigous selection : " + result.info() + directInheriting.info()));
        }
        return (T)(result == null ? this : result.adjustMeta(value, composites));
    }

    boolean isAdjusted(T directInheriting, Serializable value, List<T> composites) {
        return !composites.equals(this.getComposites()) && !((AbstractVertex)directInheriting).equalsRegardlessSupers(this, value, composites) && this.compositesDepends(composites, ((AbstractVertex)directInheriting).getComposites());
    }

    T getDirectInstance(Serializable value, List<T> composites) {
        for (AbstractVertex instance : this.getInstances()) {
            if (!instance.equalsRegardlessSupers(this, value, composites)) continue;
            return (T)instance;
        }
        return null;
    }

    T getDirectInstance(List<T> overrides, Serializable value, List<T> composites) {
        T result = this.getDirectInstance(value, composites);
        return result != null && Statics.areOverridesReached(overrides, ((AbstractVertex)result).getSupers()) ? (T)result : null;
    }

    public final T bindInstance(Class<?> clazz, boolean throwExistException, List<T> overrides, Serializable value, List<T> composites) {
        this.checkSameEngine(composites);
        this.checkSameEngine(overrides);
        Object adjustedMeta = this.adjustMeta(value, composites);
        if (!throwExistException) {
            T equivInstance = ((AbstractVertex)adjustedMeta).getDirectEquivInstance(value, composites);
            if (equivInstance != null) {
                return ((AbstractVertex)equivInstance).equalsRegardlessSupers((IVertex<?, ?>)adjustedMeta, value, (List<? extends IVertex<?, ?>>)composites) && Statics.areOverridesReached(overrides, ((AbstractVertex)equivInstance).getSupers()) ? equivInstance : ((AbstractVertex)equivInstance).update(overrides, value, composites);
            }
        } else {
            T equivInstance = ((AbstractVertex)adjustedMeta).getDirectInstance(value, composites);
            if (equivInstance != null) {
                this.getRoot().discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + equivInstance.info()));
            }
        }
        return (T)this.rebuildAll(() -> ((AbstractVertex)adjustedMeta.buildInstance(clazz, throwExistException, overrides, value, composites)).plug(), ((AbstractVertex)adjustedMeta).computePotentialDependencies(overrides, value, composites));
    }

    boolean dependsFrom(T meta, List<T> overrides, Serializable value, List<T> composites) {
        return this.inheritsFrom(meta, value, composites) || this.getComposites().stream().filter(composite -> composite != null && composite != this).anyMatch(composite -> composite.dependsFrom(meta, overrides, value, composites)) || !this.isRoot() && ((AbstractVertex)this.getMeta()).dependsFrom(meta, overrides, value, composites) || !composites.isEmpty() && this.compositesDepends(this.getComposites(), composites) && overrides.stream().anyMatch(override -> override.inheritsFrom(this.getMeta()));
    }

    T getDirectEquivInstance(Serializable value, List<T> composites) {
        for (AbstractVertex instance : this.getInstances()) {
            if (!instance.equiv(this, value, composites)) continue;
            return (T)instance;
        }
        return null;
    }

    boolean equiv(IVertex<?, ?> meta, Serializable value, List<? extends IVertex<?, ?>> composites) {
        int i;
        if (!this.getMeta().equiv(meta)) {
            return false;
        }
        if (this.getComposites().size() != composites.size()) {
            return false;
        }
        List notNullComposites = composites.stream().map(this.NULL_TO_THIS).collect(Collectors.toList());
        List<T> compositesList = this.getComposites();
        for (i = 0; i < compositesList.size(); ++i) {
            if (this.isReferentialIntegrityEnabled(i) || !this.isSingularConstraintEnabled(i) || !((AbstractVertex)compositesList.get(i)).equiv((IVertex)notNullComposites.get(i))) continue;
            return true;
        }
        for (i = 0; i < compositesList.size(); ++i) {
            if (((AbstractVertex)compositesList.get(i)).equiv((IVertex)notNullComposites.get(i))) continue;
            return false;
        }
        if (!meta.isPropertyConstraintEnabled()) {
            return Objects.equals(this.getValue(), value);
        }
        return true;
    }

    private void checkSameEngine(List<T> generics) {
        if (generics.stream().anyMatch(generic -> generic != null && !generic.getRoot().equals(this.getRoot()))) {
            this.getRoot().discardWithException((Throwable)new CrossEnginesAssignementsException());
        }
    }

    T rebuildAll(Supplier<T> rebuilder, LinkedHashSet<T> dependenciesToRebuild) {
        ConvertMap convertMap = new ConvertMap();
        dependenciesToRebuild.forEach(this::simpleRemove);
        AbstractVertex build = (AbstractVertex)rebuilder.get();
        dependenciesToRebuild.remove(this);
        convertMap.put(this, build);
        dependenciesToRebuild.forEach(x -> convertMap.convert(x));
        return (T)build;
    }

    Snapshot<T> getInheritings(T origin, int level) {
        return () -> new InheritanceComputer(this, (AbstractVertex)origin, level).inheritanceIterator();
    }

    protected abstract T newT();

    protected abstract T[] newTArray(int var1);

    public T[] coerceToTArray(Object ... array) {
        AbstractVertex[] result = this.newTArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (AbstractVertex)array[i];
        }
        return result;
    }

    public T[] addThisToTargets(T ... targets) {
        AbstractVertex[] components = this.newTArray(targets.length + 1);
        components[0] = this;
        System.arraycopy(targets, 0, components, 1, targets.length);
        return components;
    }

    T buildInstance(Class<?> clazz, boolean throwExistException, List<T> overrides, Serializable value, List<T> composites) {
        int level = this.getLevel() == 0 && Objects.equals(this.getValue(), this.getRoot().getValue()) && this.getComposites().stream().allMatch(c -> c.isRoot()) && Objects.equals(value, this.getRoot().getValue()) && composites.stream().allMatch(c -> c.isRoot()) ? 0 : this.getLevel() + 1;
        overrides.forEach(DefaultAncestors::checkIsAlive);
        composites.stream().filter(x -> x != null).forEach(DefaultAncestors::checkIsAlive);
        ArrayList supers = new ArrayList(new SupersComputer(level, this, overrides, value, composites));
        this.checkOverridesAreReached(overrides, supers);
        return (T)this.newT(clazz, throwExistException, this, supers, value, composites);
    }

    void checkOverridesAreReached(List<T> overrides, List<T> supers) {
        if (!Statics.areOverridesReached(overrides, supers)) {
            this.getRoot().discardWithException(new IllegalStateException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
    }

    boolean compositesDepends(SingularsLazyCache singulars, List<T> subComposites, List<T> superComposites) {
        int subIndex = 0;
        block0: for (AbstractVertex superComposite : superComposites) {
            while (subIndex < subComposites.size()) {
                AbstractVertex subComposite = (AbstractVertex)subComposites.get(subIndex);
                assert (subComposite != null || superComposite != null);
                if (subComposite == null && this.equals(superComposite) || superComposite == null && this.equals(subComposite) || subComposite != null && superComposite != null && subComposite.isSpecializationOf(superComposite)) {
                    if (singulars.get(subIndex)) {
                        return true;
                    }
                    ++subIndex;
                    continue block0;
                }
                ++subIndex;
            }
            return false;
        }
        return true;
    }

    boolean compositesDepends(List<T> subComposites, T ... superComposites) {
        return this.compositesDepends(subComposites, Arrays.asList(superComposites));
    }

    boolean compositesDepends(final List<T> subComposites, List<T> superComposites) {
        class SingularsLazyCacheImpl
        implements SingularsLazyCache {
            private final Boolean[] singulars;

            SingularsLazyCacheImpl() {
                this.singulars = new Boolean[subComposites.size()];
            }

            @Override
            public boolean get(int i) {
                return this.singulars[i] != null ? this.singulars[i] : Boolean.valueOf(AbstractVertex.this.isSingularConstraintEnabled(i));
            }
        }
        return this.compositesDepends(new SingularsLazyCacheImpl(), subComposites, superComposites);
    }

    protected boolean isSuperOf(T subMeta, List<T> overrides, Serializable subValue, List<T> subComposites) {
        return overrides.stream().anyMatch(override -> override.inheritsFrom(this)) || AbstractVertex.isSuperOf(subMeta, subValue, subComposites, this.getMeta(), this.getValue(), this.getComposites());
    }

    protected boolean inheritsFrom(T superMeta, Serializable superValue, List<T> superComposites) {
        return AbstractVertex.isSuperOf(this.getMeta(), this.getValue(), this.getComposites(), superMeta, superValue, superComposites);
    }

    private static <T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>> boolean isSuperOf(T subMeta, Serializable subValue, List<T> subComposites, T superMeta, Serializable superValue, List<T> superComposites) {
        if (!subMeta.inheritsFrom(superMeta)) {
            return false;
        }
        if (!((AbstractVertex)subMeta).compositesDepends(subComposites, superComposites)) {
            return false;
        }
        if (subMeta.isPropertyConstraintEnabled()) {
            return !subComposites.equals(superComposites);
        }
        return Objects.equals(subValue, superValue);
    }

    public Snapshot<T> getComponents() {
        return () -> this.getMetaComponentsDependencies().stream().map(entry -> ((Dependencies)entry.getValue()).stream()).flatMap(x -> x).iterator();
    }

    public Snapshot<T> getMetaComponents(T meta) {
        return () -> {
            Iterator iterator = this.getMetaComponentsDependencies().iterator();
            while (iterator.hasNext()) {
                Dependencies.DependenciesEntry entry = (Dependencies.DependenciesEntry)iterator.next();
                if (!meta.equals(entry.getKey())) continue;
                return ((Dependencies)entry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    public Snapshot<T> getSuperComponents(T superT) {
        return () -> {
            Iterator iterator = this.getSuperComponentsDependencies().iterator();
            while (iterator.hasNext()) {
                Dependencies.DependenciesEntry entry = (Dependencies.DependenciesEntry)iterator.next();
                if (!superT.equals(entry.getKey())) continue;
                return ((Dependencies)entry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    protected <subT extends T> subT plug() {
        AbstractVertex result = super.indexInstance((AbstractVertex)this);
        this.getSupers().forEach(superGeneric -> superGeneric.indexInheriting(this));
        this.getComposites().stream().filter(composite -> !this.equals(composite)).forEach(composite -> composite.indexByMeta(this.getMeta(), this));
        this.getSupers().forEach(superGeneric -> this.getComposites().stream().filter(composite -> !this.equals(composite)).forEach(composite -> composite.indexBySuper(superGeneric, this)));
        this.getRoot().check(Constraint.CheckingType.CHECK_ON_ADD, true, this);
        return (subT)result;
    }

    protected boolean unplug() {
        this.getRoot().check(Constraint.CheckingType.CHECK_ON_REMOVE, true, this);
        boolean result = super.unIndexInstance((AbstractVertex)this);
        if (!result) {
            this.getRoot().discardWithException((Throwable)new NotFoundException(this.info()));
        }
        this.getSupers().forEach(superGeneric -> superGeneric.unIndexInheriting(this));
        this.getComposites().stream().filter(composite -> !this.equals(composite)).forEach(composite -> composite.unIndexByMeta(this.getMeta(), this));
        this.getSupers().forEach(superGeneric -> this.getComposites().stream().filter(composite -> !this.equals(composite)).forEach(composite -> composite.unIndexBySuper(superGeneric, this)));
        return result;
    }

    private T indexByMeta(T meta, T composite) {
        return AbstractVertex.index(this.getMetaComponentsDependencies(), meta, composite);
    }

    private T indexBySuper(T superVertex, T composite) {
        return AbstractVertex.index(this.getSuperComponentsDependencies(), superVertex, composite);
    }

    private static <T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>> T index(Dependencies<Dependencies.DependenciesEntry<T>> multimap, T index, T composite) {
        Iterator iterator = multimap.iterator();
        while (iterator.hasNext()) {
            Dependencies.DependenciesEntry entry = (Dependencies.DependenciesEntry)iterator.next();
            if (!index.equals(entry.getKey())) continue;
            return ((Dependencies)entry.getValue()).set(composite);
        }
        Dependencies dependencies = composite.buildDependencies();
        AbstractVertex result = (AbstractVertex)dependencies.set(composite);
        multimap.set(new Dependencies.DependenciesEntry<T>(index, dependencies));
        return (T)result;
    }

    private static <T> boolean unIndex(Dependencies<Dependencies.DependenciesEntry<T>> multimap, T index, T composite) {
        Iterator iterator = multimap.iterator();
        while (iterator.hasNext()) {
            Dependencies.DependenciesEntry entry = (Dependencies.DependenciesEntry)iterator.next();
            if (!index.equals(entry.getKey())) continue;
            return ((Dependencies)entry.getValue()).remove(composite);
        }
        return false;
    }

    private boolean unIndexByMeta(T meta, T composite) {
        return AbstractVertex.unIndex(this.getMetaComponentsDependencies(), meta, composite);
    }

    private boolean unIndexBySuper(T superT, T composite) {
        return AbstractVertex.unIndex(this.getSuperComponentsDependencies(), superT, composite);
    }

    private static <T> T index(Dependencies<T> dependencies, T dependency) {
        return dependencies.set(dependency);
    }

    private static <T> boolean unIndex(Dependencies<T> dependencies, T dependency) {
        return dependencies.remove(dependency);
    }

    public Snapshot<T> getInstances() {
        return this.getInstancesDependencies();
    }

    public Snapshot<T> getInheritings() {
        return this.getInheritingsDependencies();
    }

    private T indexInstance(T instance) {
        return (T)((AbstractVertex)AbstractVertex.index(this.getInstancesDependencies(), instance));
    }

    private T indexInheriting(T inheriting) {
        return (T)((AbstractVertex)AbstractVertex.index(this.getInheritingsDependencies(), inheriting));
    }

    private boolean unIndexInstance(T instance) {
        return AbstractVertex.unIndex(this.getInstancesDependencies(), instance);
    }

    private boolean unIndexInheriting(T inheriting) {
        return AbstractVertex.unIndex(this.getInheritingsDependencies(), inheriting);
    }

    boolean equalsRegardlessSupers(IVertex<?, ?> meta, Serializable value, List<? extends IVertex<?, ?>> composites) {
        return (this.isRoot() || this.getMeta().equals(meta)) && Objects.equals(this.getValue(), value) && this.getComposites().equals(composites.stream().map(this.NULL_TO_THIS).collect(Collectors.toList()));
    }

    T getMap() {
        return (T)this.getRoot().getMetaAttribute().getDirectInstance((Serializable)((Object)SystemMap.class), (List<T>)Collections.singletonList((AbstractVertex)this.getRoot()));
    }

    protected boolean equals(ISignature<?> meta, List<? extends ISignature<?>> supers, Serializable value, List<? extends ISignature<?>> composites) {
        return (this.isRoot() || this.getMeta().equals(meta)) && Objects.equals(this.getValue(), value) && this.getComposites().equals(composites.stream().map(this.NULL_TO_THIS).collect(Collectors.toList())) && this.getSupers().equals(supers);
    }

    protected Stream<T> getKeys() {
        T map = this.getMap();
        return map != null ? this.getAttributes((AbstractVertex)map).stream() : Stream.empty();
    }

    Optional<T> getKey(AxedPropertyClass property) {
        return this.getKeys().filter(x -> Objects.equals(x.getValue(), property)).findFirst();
    }

    void checkSystemConstraints(Constraint.CheckingType checkingType, boolean isFlushTime) {
        this.checkDependsMetaComposites();
        this.checkSupers();
        this.checkDependsSuperComposites();
        this.checkLevel();
        this.checkLevelComposites();
        for (Class<? extends Constraint> constraintClass : DefaultRoot.SYSTEM_CONSTRAINTS) {
            try {
                Constraint constraint = constraintClass.newInstance();
                if (!this.isCheckable(constraint, checkingType, isFlushTime)) continue;
                constraint.check(this, this);
            }
            catch (IllegalAccessException | InstantiationException | ConstraintViolationException e) {
                this.getRoot().discardWithException(e);
            }
        }
    }

    private void checkDependsMetaComposites() {
        if (!((AbstractVertex)this.getMeta()).compositesDepends(this.getComposites(), ((AbstractVertex)this.getMeta()).getComposites())) {
            this.getRoot().discardWithException((Throwable)new ConsistencyConstraintViolationException("Inconsistant components : " + this.getComposites() + " " + ((AbstractVertex)this.getMeta()).getComposites()));
        }
    }

    private void checkLevelComposites() {
        if (this.getComposites().stream().anyMatch(composite -> composite.getLevel() > this.getLevel())) {
            this.getRoot().discardWithException((Throwable)new ConsistencyConstraintViolationException("Inconsistant level link between components : level " + this.getLevel() + " and another"));
        }
    }

    private void checkLevel() {
        if (this.getLevel() > 2) {
            this.getRoot().discardWithException((Throwable)new ConsistencyConstraintViolationException("Unable to instanciate generic : " + this.getMeta() + " because it is already concrete."));
        }
    }

    private void checkSupers() {
        this.supers.forEach(DefaultAncestors::checkIsAlive);
        if (!this.supers.stream().allMatch(superVertex -> superVertex.getLevel() == this.getLevel())) {
            this.getRoot().discardWithException(new IllegalStateException("Inconsistant supers : " + this.supers));
        }
        if (!this.supers.stream().allMatch(superVertex -> this.getMeta().inheritsFrom(superVertex.getMeta()))) {
            this.getRoot().discardWithException(new IllegalStateException("Inconsistant supers : " + this.supers));
        }
        if (!this.supers.stream().noneMatch(this::equals)) {
            this.getRoot().discardWithException(new IllegalStateException("Supers loop detected : " + this.info()));
        }
        if (this.supers.stream().anyMatch(superVertex -> Objects.equals(superVertex.getValue(), this.getValue()) && superVertex.getComposites().equals(this.getComposites()) && this.getMeta().inheritsFrom(superVertex.getMeta()))) {
            this.getRoot().discardWithException(new IllegalStateException("Collision detected : " + this.info()));
        }
    }

    private void checkDependsSuperComposites() {
        this.getSupers().forEach(superVertex -> {
            if (!superVertex.isSuperOf(this.getMeta(), this.supers, this.getValue(), this.getComposites())) {
                this.getRoot().discardWithException(new IllegalStateException("Inconsistant composites : " + this.getComposites()));
            }
        });
    }

    void checkConstraints(Constraint.CheckingType checkingType, boolean isFlushTime) {
        for (AbstractVertex constraintHolder : this.getActivedConstraints()) {
            try {
                Constraint constraint = this.newConstraint(constraintHolder);
                if (!this.isCheckable(constraint, checkingType, isFlushTime)) continue;
                int axe = ((AxedPropertyClass)constraintHolder.getValue()).getAxe();
                constraint.check(this, (DefaultVertex)((AbstractVertex)this.getHolders(constraintHolder).iterator().next()).getComposites().get(0));
            }
            catch (ConstraintViolationException e) {
                this.getRoot().discardWithException(e);
            }
        }
    }

    private List<T> getActivedConstraints() {
        return this.getKeys().filter(x -> x.getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)x.getValue()).getClazz())).filter(x -> {
            Iterator holders = this.getHolders((AbstractVertex)x).iterator();
            return holders.hasNext() && !((AbstractVertex)holders.next()).getValue().equals(Boolean.FALSE);
        }).sorted(this.priorityConstraintComparator).collect(Collectors.toList());
    }

    private Constraint newConstraint(T constraintHolder) {
        try {
            return (Constraint)((AxedPropertyClass)((AbstractVertex)constraintHolder).getValue()).getClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.getRoot().discardWithException(e);
            return null;
        }
    }

    private boolean isCheckable(Constraint constraint, Constraint.CheckingType checkingType, boolean isFlushTime) {
        return (isFlushTime || constraint.isImmediatelyCheckable()) && constraint.isCheckedAt(this, checkingType);
    }

    void checkConsistency(Constraint.CheckingType checkingType, boolean isFlushTime) {
    }

    public static class SystemMap {
    }

    static interface SingularsLazyCache {
        public boolean get(int var1);
    }

    private static class ConvertMap<T extends AbstractVertex<T, U>, U extends DefaultRoot<T, U>>
    extends HashMap<T, T> {
        private static final long serialVersionUID = 5003546962293036021L;

        private ConvertMap() {
        }

        T convert(T dependency) {
            if (dependency.isAlive()) {
                return dependency;
            }
            AbstractVertex newDependency = (AbstractVertex)this.get(dependency);
            if (newDependency == null) {
                Object meta = dependency.isRoot() ? dependency : this.convert(((AbstractVertex)dependency).getMeta());
                List composites = ((AbstractVertex)dependency).getComposites().stream().map(x -> x.equals(this) ? null : this.convert(x)).collect(Collectors.toList());
                meta = ((AbstractVertex)meta).adjustMeta(((AbstractVertex)dependency).getValue(), composites);
                newDependency = ((AbstractVertex)((AbstractVertex)meta).buildInstance(null, ((AbstractVertex)dependency).isThrowExistException(), ((AbstractVertex)dependency).getSupers().stream().map(x -> this.convert(x)).collect(Collectors.toList()), ((AbstractVertex)dependency).getValue(), composites)).plug();
                this.put(dependency, newDependency);
            }
            return (T)newDependency;
        }
    }
}

