/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.SystemPropertiesService;
import org.genericsystem.kernel.services.VertexService;

public interface MapService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    @Override
    default public Serializable getSystemPropertyValue(Class<?> propertyClass, int pos) {
        Optional<Serializable> result;
        Optional<T> key = this.getKey(new SystemPropertiesService.AxedPropertyClass(propertyClass, pos));
        if (key.isPresent() && (result = this.getValues((ApiService)key.get()).stream().findFirst()).isPresent()) {
            return result.get();
        }
        return null;
    }

    @Override
    default public void setSystemPropertyValue(Class<T> propertyClass, int pos, Serializable value) {
        ((VertexService)this.getMap().getMeta()).setInstance((VertexService)this.getMap(), new SystemPropertiesService.AxedPropertyClass(propertyClass, pos), (VertexService[])this.coerceToArray(new Object[]{this.getRoot()})).setInstance(value, (VertexService[])this.coerceToArray(new Object[]{this}));
    }

    @Override
    default public T getMap() {
        VertexService metaAttribute = (VertexService)this.getMetaAttribute();
        for (VertexService instance : metaAttribute.getInstances()) {
            if (!instance.equiv(metaAttribute, (Serializable)((Object)SystemMap.class), Collections.singletonList(this.getRoot()))) continue;
            return (T)instance;
        }
        return null;
    }

    @Override
    default public Stream<T> getKeys() {
        ApiService map = this.getMap();
        if (map == null) {
            return Stream.empty();
        }
        return this.getAttributes(map).stream();
    }

    @Override
    default public Optional<T> getKey(SystemPropertiesService.AxedPropertyClass property) {
        return this.getKeys().filter(x -> x.getValue().equals(property)).findFirst();
    }

    public static class SystemMap {
    }
}

