/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.genericsystem.kernel.exceptions.NotAliveException;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AncestorsService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    public static final Logger log = LoggerFactory.getLogger(AncestorsService.class);
    public static final BiPredicate<Serializable, Serializable> VALUE_EQUALS = (X, Y) -> Objects.equals(X, Y);
    public static final BiPredicate<Serializable, Serializable> VALUE_IGNORED = (X, Y) -> true;
    public static final BiPredicate<Serializable, Serializable> KEY_EQUALS = (X, Y) -> X instanceof Map.Entry && Y instanceof Map.Entry && Objects.equals(((Map.Entry)((Object)X)).getKey(), ((Map.Entry)((Object)Y)).getKey());
    public static final BiPredicate<List<? extends AncestorsService<?, ?>>, List<? extends AncestorsService<?, ?>>> SIZE_EQUALS = (X, Y) -> X.size() == Y.size();

    @Override
    default public Stream<T> getComponentsStream() {
        return this.getComponents().stream();
    }

    @Override
    default public boolean isRoot() {
        return false;
    }

    @Override
    default public boolean isAlive() {
        return this.equals(this.getAlive());
    }

    @Override
    default public T checkIsAlive() {
        ApiService result = this.getAlive();
        if (!this.equals(this.getAlive())) {
            this.getRoot().discardWithException(new NotAliveException(this.info()));
        }
        return (T)result;
    }

    @Override
    default public T getAlive() {
        ApiService pluggedMeta = ((VertexService)this.getMeta()).getAlive();
        if (pluggedMeta == null) {
            return null;
        }
        for (VertexService instance : pluggedMeta.getInstances()) {
            if (!this.equiv(instance)) continue;
            return (T)instance;
        }
        return null;
    }

    @Override
    default public T getWeakAlive() {
        ApiService pluggedMeta = ((VertexService)this.getMeta()).getAlive();
        if (pluggedMeta == null) {
            return null;
        }
        for (VertexService instance : pluggedMeta.getInstances()) {
            if (!this.weakEquiv(instance)) continue;
            return (T)instance;
        }
        return null;
    }

    @Override
    default public boolean equiv(ApiService<? extends ApiService<?, ?>, ?> service) {
        return this.equiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    @Override
    default public boolean equiv(ApiService<?, ?> meta, Serializable value, List<? extends ApiService<?, ?>> components) {
        return (this.isRoot() || ((VertexService)this.getMeta()).equiv(meta)) && Objects.equals(this.getValue(), value) && AncestorsService.listsEquiv(this.getComponents(), components);
    }

    @Override
    default public boolean equals(ApiService<?, ?> meta, List<? extends ApiService<?, ?>> supers, Serializable value, List<? extends ApiService<?, ?>> components) {
        return (this.isRoot() || ((VertexService)this.getMeta()).equals(meta)) && Objects.equals(this.getValue(), value) && AncestorsService.listsEquals(this.getSupers(), supers) && AncestorsService.listsEquals(this.getComponents(), components);
    }

    public static boolean listsEquals(List<? extends ApiService<?, ?>> components, List<? extends ApiService<?, ?>> otherComponents) {
        if (otherComponents.size() != components.size()) {
            return false;
        }
        Iterator<? extends ApiService<?, ?>> otherComponentsIt = otherComponents.iterator();
        return components.stream().allMatch(x -> x.equals(otherComponentsIt.next()));
    }

    public static boolean listsEquiv(List<? extends ApiService<?, ?>> components, List<? extends ApiService<?, ?>> otherComponents) {
        if (otherComponents.size() != components.size()) {
            return false;
        }
        Iterator<? extends ApiService<?, ?>> otherComponentsIt = otherComponents.iterator();
        return components.stream().allMatch(x -> x.equiv((ApiService)otherComponentsIt.next()));
    }

    @Override
    default public boolean weakEquiv(ApiService<? extends ApiService<?, ?>, ?> service) {
        return service == this ? true : this.weakEquiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    @Override
    default public boolean weakEquiv(ApiService<?, ?> meta, Serializable value, List<? extends ApiService<?, ?>> components) {
        return ((VertexService)this.getMeta()).weakEquiv(meta) && ((VertexService)this.getMeta()).getWeakPredicate().test(this.getValue(), this.getComponents(), value, components);
    }

    @Override
    default public ApiService.WeakPredicate getWeakPredicate() {
        return (value, components, otherValue, otherComponents) -> this.singularOrReferential(components, otherComponents) || this.weakEquiv(components, otherComponents) && this.getValuesBiPredicate().test(value, otherValue);
    }

    @Override
    default public boolean singularOrReferential(List<? extends ApiService<?, ?>> components, List<? extends ApiService<?, ?>> otherComponents) {
        if (components.size() != otherComponents.size()) {
            return false;
        }
        for (int i = 0; i < otherComponents.size(); ++i) {
            if (!this.isReferentialIntegrityConstraintEnabled(i) || !this.isSingularConstraintEnabled(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean weakEquiv(List<? extends ApiService<?, ?>> components, List<? extends ApiService<?, ?>> otherComponents) {
        if (components.size() != otherComponents.size()) {
            return false;
        }
        Iterator<? extends ApiService<?, ?>> otherComponentsIt = otherComponents.iterator();
        return components.stream().allMatch(x -> x.weakEquiv((ApiService)otherComponentsIt.next()));
    }

    @Override
    default public BiPredicate<Serializable, Serializable> getValuesBiPredicate() {
        return this.isPropertyConstraintEnabled() ? VALUE_IGNORED : VALUE_EQUALS.or(KEY_EQUALS);
    }

    @Override
    default public int getLevel() {
        return this.isRoot() || this.getValue().equals(this.getRoot().getValue()) || this.getComponentsStream().allMatch(c -> c.isRoot()) ? 0 : ((VertexService)this.getMeta()).getLevel() + 1;
    }

    @Override
    default public U getRoot() {
        return (U)((VertexService)this.getMeta()).getRoot();
    }

    @Override
    default public boolean isMeta() {
        return this.getLevel() == 0;
    }

    @Override
    default public boolean isStructural() {
        return this.getLevel() == 1;
    }

    @Override
    default public boolean isConcrete() {
        return this.getLevel() == 2;
    }

    @Override
    default public Stream<T> getSupersStream() {
        return this.getSupers().stream();
    }

    @Override
    default public boolean inheritsFrom(T superVertex) {
        if (this.equals(superVertex)) {
            return true;
        }
        if (this.getLevel() != superVertex.getLevel()) {
            return false;
        }
        return this.getSupersStream().anyMatch(vertex -> vertex.inheritsFrom(superVertex));
    }

    @Override
    default public boolean isInstanceOf(T metaVertex) {
        return ((VertexService)this.getMeta()).inheritsFrom(metaVertex);
    }

    @Override
    default public boolean isSpecializationOf(T supra) {
        return this.getLevel() == supra.getLevel() ? this.inheritsFrom(supra) : this.getLevel() > supra.getLevel() && ((VertexService)this.getMeta()).isSpecializationOf(supra);
    }

    @Override
    default public boolean isAttributeOf(T vertex) {
        return this.isRoot() || this.getComponentsStream().anyMatch(component -> vertex.isSpecializationOf((Object)component));
    }
}

