/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public abstract class Signature<T extends Signature<T, U>, U extends RootService<T, U>>
implements VertexService<T, U> {
    private T meta;
    private List<T> components;
    private Serializable value;
    protected boolean throwExistException;

    protected T init(boolean throwExistException, T meta, Serializable value, List<T> components) {
        this.throwExistException = throwExistException;
        if (meta != null) {
            meta.checkIsAlive();
            this.meta = meta;
        } else {
            this.meta = this;
        }
        this.value = value;
        this.components = new ArrayList<T>(components);
        for (int i = 0; i < components.size(); ++i) {
            Signature component = (Signature)components.get(i);
            if (component != null) {
                component.checkIsAlive();
                this.components.set(i, component);
                continue;
            }
            this.components.set(i, this);
        }
        return (T)this;
    }

    public boolean isThrowExistException() {
        return this.throwExistException;
    }

    @Override
    public T getMeta() {
        return this.meta;
    }

    @Override
    public List<T> getComponents() {
        return this.components;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }

    @Override
    public int getLevel() {
        return this.isRoot() || this.components.stream().allMatch(c -> c.isRoot()) && Objects.equals(this.getValue(), this.getRoot().getValue()) ? 0 : ((Signature)this.meta).getLevel() + 1;
    }
}

