/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.kernel.exceptions.AmbiguousSelectionException;
import org.genericsystem.kernel.exceptions.CrossEnginesAssignementsException;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public interface BindingService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    @Override
    default public void checkSameEngine(List<T> generics) {
        if (generics.stream().anyMatch(generic -> !generic.getRoot().equals(this.getRoot()))) {
            ((RootService)this.getRoot()).discardWithException(new CrossEnginesAssignementsException());
        }
    }

    @Override
    default public T adjustMeta(List<T> overrides, Serializable subValue, List<T> subComponents) {
        ApiService result = null;
        for (VertexService directInheriting : this.getInheritings()) {
            if (directInheriting.equiv(this, subValue, subComponents)) {
                return (T)((VertexService)this);
            }
            if (!this.isSpecializationOf(this.getMeta()) || !this.componentsDepends(subComponents, directInheriting.getComponents())) continue;
            if (result == null) {
                result = directInheriting;
                continue;
            }
            ((RootService)this.getRoot()).discardWithException(new AmbiguousSelectionException("Ambigous selection : " + result.info() + directInheriting.info()));
        }
        return (T)(result == null ? (VertexService)this : result.adjustMeta(overrides, subValue, subComponents));
    }

    @Override
    default public T getInstance(Serializable value, T ... components) {
        ApiService meta = (VertexService)this.getAlive();
        if (meta == null) {
            return null;
        }
        meta = this.adjustMeta(Collections.emptyList(), value, (List)Arrays.asList(components));
        if (meta != this) {
            return (T)meta.getInstance(value, (VertexService[])components);
        }
        for (VertexService instance : meta.getInstances()) {
            if (!instance.equiv(meta, value, Arrays.asList(components))) continue;
            return (T)instance;
        }
        return null;
    }

    @Override
    default public <subT extends T> subT getWeakInstance(Serializable value, List<T> components) {
        ApiService meta = (VertexService)this.getAlive();
        if (meta == null) {
            return null;
        }
        meta = this.adjustMeta(Collections.emptyList(), value, (List)components);
        if (meta != this) {
            return meta.getWeakInstance(value, components);
        }
        for (VertexService instance : meta.getInstances()) {
            if (!instance.weakEquiv(meta, value, components)) continue;
            return (subT)instance;
        }
        return null;
    }

    @Override
    default public T getInstance(List<T> supers, Serializable value, T ... components) {
        VertexService result = this.getInstance(value, (VertexService[])components);
        return (T)(result != null && supers.stream().allMatch(superT -> result.inheritsFrom(superT)) ? result : null);
    }
}

