/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public class SupersComputer<T extends VertexService<T, U>, U extends RootService<T, U>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -1078004898524170057L;
    private final int level;
    private final T meta;
    private final List<T> overrides;
    private final List<T> components;
    private final Serializable value;
    private final Map<T, Boolean> alreadyComputed = new HashMap<T, Boolean>();

    public SupersComputer(int level, T meta, List<T> overrides, Serializable value, List<T> components) {
        this.level = level;
        this.meta = meta;
        this.overrides = overrides;
        this.components = components;
        this.value = value;
        this.visit(meta.getRoot());
    }

    private boolean visit(T candidate) {
        boolean isSuper;
        Boolean result = this.alreadyComputed.get(candidate);
        if (result != null) {
            return result;
        }
        boolean isMeta = this.meta.isSpecializationOf(candidate);
        boolean bl = isSuper = !isMeta && candidate.isSuperOf(this.meta, this.overrides, this.value, this.components);
        if (!isMeta && !isSuper) {
            this.alreadyComputed.put(candidate, false);
            return false;
        }
        boolean selectable = true;
        for (VertexService inheriting : candidate.getInheritings()) {
            assert (!inheriting.equals(candidate));
            assert (!candidate.equals(inheriting)) : candidate.info() + inheriting.info();
            if (!this.visit(inheriting)) continue;
            selectable = false;
        }
        if (isMeta) {
            for (VertexService instance : candidate.getInstances()) {
                assert (!instance.equals(candidate));
                assert (!candidate.equals(instance));
                if (!this.visit(instance)) continue;
                selectable = false;
            }
        }
        result = this.alreadyComputed.put(candidate, selectable);
        assert (result == null) : candidate.info();
        if (selectable && candidate.getLevel() == this.level && !candidate.equiv((ApiService<?, ?>)this.meta, this.value, (List<? extends ApiService<?, ?>>)this.components)) {
            this.add(candidate);
        }
        return selectable;
    }
}

