/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.services.SystemPropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ApiService<T extends ApiService<T, U>, U extends ApiService<T, U>> {
    public static final Logger log = LoggerFactory.getLogger(ApiService.class);

    public T getMeta();

    public Serializable getValue();

    public List<T> getComponents();

    public Stream<T> getComponentsStream();

    public boolean isRoot();

    public boolean isAlive();

    public T checkIsAlive();

    public T getAlive();

    public T getWeakAlive();

    public boolean equiv(ApiService<? extends ApiService<?, ?>, ?> var1);

    public boolean equiv(ApiService<?, ?> var1, Serializable var2, List<? extends ApiService<?, ?>> var3);

    public boolean equals(ApiService<?, ?> var1, List<? extends ApiService<?, ?>> var2, Serializable var3, List<? extends ApiService<?, ?>> var4);

    public boolean weakEquiv(ApiService<? extends ApiService<?, ?>, ?> var1);

    public boolean weakEquiv(ApiService<?, ?> var1, Serializable var2, List<? extends ApiService<?, ?>> var3);

    public WeakPredicate getWeakPredicate();

    public boolean singularOrReferential(List<? extends ApiService<?, ?>> var1, List<? extends ApiService<?, ?>> var2);

    public boolean weakEquiv(List<? extends ApiService<?, ?>> var1, List<? extends ApiService<?, ?>> var2);

    public BiPredicate<Serializable, Serializable> getValuesBiPredicate();

    public T[] coerceToArray(Object ... var1);

    public T[] targetsToComponents(T ... var1);

    public int getLevel();

    public U getRoot();

    public boolean isMeta();

    public boolean isStructural();

    public boolean isConcrete();

    public List<T> getSupers();

    public Stream<T> getSupersStream();

    public boolean inheritsFrom(T var1);

    public boolean isInstanceOf(T var1);

    public boolean isSpecializationOf(T var1);

    public boolean isAttributeOf(T var1);

    public void checkSameEngine(List<T> var1);

    public T adjustMeta(List<T> var1, Serializable var2, List<T> var3);

    public T getInstance(Serializable var1, T ... var2);

    public <subT extends T> subT getWeakInstance(Serializable var1, List<T> var2);

    public T getInstance(List<T> var1, Serializable var2, T ... var3);

    public Snapshot<T> getInheritings(T var1, int var2);

    public Snapshot<T> getMetaComposites(T var1);

    public Snapshot<T> getSuperComposites(T var1);

    public Snapshot<T> getAttributes();

    public Snapshot<T> getAttributes(T var1);

    public Snapshot<T> getHolders(T var1);

    public Snapshot<Serializable> getValues(T var1);

    public Snapshot<T> getInstances();

    public Snapshot<T> getInheritings();

    public Snapshot<T> getComposites();

    public boolean isAncestorOf(T var1);

    public boolean isSuperOf(T var1, List<T> var2, Serializable var3, List<T> var4);

    public boolean inheritsFrom(T var1, Serializable var2, List<T> var3);

    public boolean componentsDepends(List<T> var1, List<T> var2);

    public Snapshot<T> getAllInheritings();

    public Snapshot<T> getAllInstances();

    public String info();

    public void log();

    public void log(String var1);

    public String detailedInfo();

    public T getMap();

    public Stream<T> getKeys();

    public Optional<T> getKey(SystemPropertiesService.AxedPropertyClass var1);

    public Serializable getSystemPropertyValue(Class<?> var1, int var2);

    public void setSystemPropertyValue(Class<T> var1, int var2, Serializable var3);

    public T enableSystemProperty(Class<?> var1, int var2);

    public T disableSystemProperty(Class<?> var1, int var2);

    public boolean isSystemPropertyEnabled(Class<?> var1, int var2);

    public T enableReferentialIntegrity(int var1);

    public T disableReferentialIntegrity(int var1);

    public boolean isReferentialIntegrityConstraintEnabled(int var1);

    public T enableSingularConstraint(int var1);

    public T disableSingularConstraint(int var1);

    public boolean isSingularConstraintEnabled(int var1);

    public T enablePropertyConstraint();

    public T disablePropertyConstraint();

    public boolean isPropertyConstraintEnabled();

    public T enableRequiredConstraint(int var1);

    public T disableRequiredConstraint(int var1);

    public boolean isRequiredConstraintEnabled(int var1);

    public T enableCascadeRemove(int var1);

    public T disableCascadeRemove(int var1);

    public boolean isCascadeRemove(int var1);

    public void remove();

    public T updateValue(Serializable var1);

    public T updateSupers(T ... var1);

    public T updateComponents(T ... var1);

    public T update(List<T> var1, Serializable var2, T ... var3);

    public T update(Serializable var1, T ... var2);

    public <subT extends T> subT setInstance(Serializable var1, T ... var2);

    public <subT extends T> subT setInstance(T var1, Serializable var2, T ... var3);

    public <subT extends T> subT setInstance(List<T> var1, Serializable var2, T ... var3);

    public <subT extends T> subT bindInstance(Class<?> var1, boolean var2, List<T> var3, Serializable var4, List<T> var5);

    public T getMetaAttribute();

    public <subT extends T> subT addInstance(Serializable var1, T ... var2);

    public <subT extends T> subT addInstance(T var1, Serializable var2, T ... var3);

    public <subT extends T> subT addInstance(List<T> var1, Serializable var2, T ... var3);

    public T addAttribute(Serializable var1, T ... var2);

    public T setAttribute(Serializable var1, T ... var2);

    public T addHolder(T var1, Serializable var2, T ... var3);

    public T setHolder(T var1, Serializable var2, T ... var3);

    public T addAttribute(T var1, Serializable var2, T ... var3);

    public T setAttribute(T var1, Serializable var2, T ... var3);

    public T addHolder(T var1, T var2, Serializable var3, T ... var4);

    public T setHolder(T var1, T var2, Serializable var3, T ... var4);

    public T addAttribute(List<T> var1, Serializable var2, T ... var3);

    public T setAttribute(List<T> var1, Serializable var2, T ... var3);

    public T addHolder(T var1, List<T> var2, Serializable var3, T ... var4);

    public T setHolder(T var1, List<T> var2, Serializable var3, T ... var4);

    public static interface Constraint
    extends SystemProperty {
    }

    public static interface SystemProperty {
    }

    @FunctionalInterface
    public static interface WeakPredicate {
        public boolean test(Serializable var1, List<? extends ApiService<?, ?>> var2, Serializable var3, List<? extends ApiService<?, ?>> var4);
    }
}

