/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Iterator;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.iterator.AbstractGeneralAwareIterator;

class DependenciesImpl<T>
extends Snapshot.AbstractSnapshot<T>
implements Dependencies<T> {
    private Node<T> head = null;
    private Node<T> tail = null;

    DependenciesImpl() {
    }

    @Override
    public void add(T element) {
        assert (!this.contains(element));
        assert (element != null);
        Node newNode = new Node(element);
        if (this.head == null) {
            this.head = newNode;
        } else {
            this.tail.next = newNode;
        }
        this.tail = newNode;
    }

    @Override
    public boolean remove(T element) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!element.equals(iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    private static class Node<T> {
        final T content;
        Node<T> next;

        private Node(T content) {
            this.content = content;
        }
    }

    private class InternalIterator
    extends AbstractGeneralAwareIterator<Node<T>, T>
    implements Iterator<T> {
        private Node<T> last;

        private InternalIterator() {
        }

        @Override
        protected void advance() {
            this.last = (Node)this.next;
            this.next = this.next == null ? DependenciesImpl.this.head : ((Node)this.next).next;
        }

        @Override
        public T project() {
            return ((Node)this.next).content;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            if (this.last == null) {
                DependenciesImpl.this.head = ((Node)this.next).next;
                return;
            }
            this.last.next = ((Node)this.next).next;
            if (((Node)this.next).next == null) {
                DependenciesImpl.this.tail = this.last;
            }
        }
    }
}

