/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.DependenciesComputer;
import org.genericsystem.kernel.DependenciesImpl;
import org.genericsystem.kernel.InheritanceComputer;
import org.genericsystem.kernel.Signature;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.SupersComputer;
import org.genericsystem.kernel.exceptions.AliveConstraintViolationException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;
import org.genericsystem.kernel.exceptions.ExistsException;
import org.genericsystem.kernel.exceptions.NotFoundException;
import org.genericsystem.kernel.exceptions.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.MapService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.SystemPropertiesService;
import org.genericsystem.kernel.services.VertexService;

public abstract class AbstractVertex<T extends AbstractVertex<T, U>, U extends RootService<T, U>>
extends Signature<T, U>
implements VertexService<T, U> {
    protected List<T> supers;

    protected abstract Dependencies<T> getInstancesDependencies();

    protected abstract Dependencies<T> getInheritingsDependencies();

    protected abstract Dependencies<Dependencies.DependenciesEntry<T>> getMetaComposites();

    protected abstract Dependencies<Dependencies.DependenciesEntry<T>> getSuperComposites();

    protected <subT extends T> subT init(boolean throwExistException, T meta, List<T> supers, Serializable value, List<T> components) {
        super.init(throwExistException, meta, value, components);
        this.supers = supers;
        this.checkDependsMetaComponents();
        this.checkSupers(supers);
        this.checkDependsSuperComponents(supers);
        return (subT)this;
    }

    protected <subT extends T> subT newT(Class<?> clazz, boolean throwExistException, T meta, List<T> supers, Serializable value, List<T> components) {
        return ((AbstractVertex)this.newT(clazz)).init(throwExistException, meta, supers, value, components);
    }

    private void checkDependsMetaComponents() {
        Serializable value = this.getValue();
        if (value.equals(MapService.SystemMap.class) || value instanceof SystemPropertiesService.AxedPropertyClass && ((SystemPropertiesService.AxedPropertyClass)value).getClazz().equals(SystemPropertiesService.PropertyConstraint.class)) {
            return;
        }
        assert (((AbstractVertex)this.getMeta()).getComponents() != null);
        if (!((AbstractVertex)this.getMeta()).componentsDepends(this.getComponents(), ((AbstractVertex)this.getMeta()).getComponents())) {
            this.getRoot().discardWithException(new IllegalStateException("Inconsistant components : " + this.getComponents() + " " + ((AbstractVertex)this.getMeta()).getComponents()));
        }
    }

    private void checkSupers(List<T> supers) {
        supers.forEach(AncestorsService::checkIsAlive);
        if (!supers.stream().allMatch(superVertex -> superVertex.getLevel() == this.getLevel())) {
            this.getRoot().discardWithException(new IllegalStateException("Inconsistant supers : " + this.getSupers()));
        }
        if (!supers.stream().allMatch(superVertex -> ((AbstractVertex)this.getMeta()).inheritsFrom(superVertex.getMeta()))) {
            this.getRoot().discardWithException(new IllegalStateException("Inconsistant supers : " + this.getSupers()));
        }
        if (!supers.stream().noneMatch(this::equals)) {
            this.getRoot().discardWithException(new IllegalStateException("Supers loop detected : " + this.info()));
        }
    }

    private void checkDependsSuperComponents(List<T> supers) {
        this.getSupersStream().forEach(superVertex -> {
            if (!superVertex.isSuperOf((AbstractVertex)this.getMeta(), supers, this.getValue(), this.getComponents())) {
                this.getRoot().discardWithException(new IllegalStateException("Inconsistant components : " + this.getComponentsStream().collect(Collectors.toList())));
            }
        });
    }

    @Override
    public List<T> getSupers() {
        return this.supers;
    }

    protected <H> Dependencies<H> buildDependencies() {
        return new DependenciesImpl();
    }

    protected void forceRemove() {
        this.computeDependencies().forEach(this::simpleRemove);
    }

    private void simpleRemove(T vertex) {
        if (!vertex.isAlive()) {
            this.getRoot().discardWithException(new AliveConstraintViolationException(vertex.info() + " is not alive"));
        }
        if (!(((AbstractVertex)vertex).getInstances().isEmpty() && ((AbstractVertex)vertex).getInheritings().isEmpty() && ((AbstractVertex)vertex).getComposites().isEmpty())) {
            this.getRoot().discardWithException(new IllegalStateException(vertex.info() + " has dependencies"));
        }
        ((AbstractVertex)vertex).unplug();
    }

    private LinkedHashSet<T> buildOrderedDependenciesToRemove() throws ReferentialIntegrityConstraintViolationException {
        final AbstractVertex restructoratorService = this;
        return new LinkedHashSet<T>(){
            private static final long serialVersionUID = -3610035019789480505L;
            {
                this.visit(restructoratorService);
            }

            public void visit(T generic) throws ReferentialIntegrityConstraintViolationException {
                if (this.add(generic)) {
                    if (!((AbstractVertex)generic).getInheritings().isEmpty() || !((AbstractVertex)generic).getInstances().isEmpty()) {
                        throw new ReferentialIntegrityConstraintViolationException("Ancestor : " + generic + " has an inheritance or instance dependency");
                    }
                    for (AbstractVertex composite : ((AbstractVertex)generic).getComposites()) {
                        if (generic.equals(composite)) continue;
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (((AbstractVertex)composite.getComponents().get(componentPos)).equals(generic) || this.contains(composite) || !composite.isReferentialIntegrityConstraintEnabled(componentPos)) continue;
                            throw new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + generic + " by component position : " + componentPos);
                        }
                        this.visit(composite);
                    }
                    for (int axe = 0; axe < ((Signature)generic).getComponents().size(); ++axe) {
                        if (!generic.isCascadeRemove(axe)) continue;
                        this.visit((AbstractVertex)((Signature)generic).getComponents().get(axe));
                    }
                }
            }
        };
    }

    private Iterable<T> reverseLinkedHashSet(LinkedHashSet<T> linkedHashSet) {
        ArrayList<T> dependencies = new ArrayList<T>(linkedHashSet);
        Collections.reverse(dependencies);
        return dependencies;
    }

    private Iterable<T> getOrderedDependenciesToRemove() throws ConstraintViolationException {
        return this.reverseLinkedHashSet(this.buildOrderedDependenciesToRemove());
    }

    @Override
    public void remove() {
        try {
            this.getOrderedDependenciesToRemove().forEach(x -> this.simpleRemove(x));
        }
        catch (ConstraintViolationException e) {
            this.getRoot().discardWithException(e);
        }
    }

    @Override
    public T update(List<T> supersToAdd, Serializable newValue, T ... newComponents) {
        return (T)this.update(supersToAdd, newValue, Arrays.asList(newComponents));
    }

    protected <subT extends T> subT update(List<T> supersToAdd, Serializable newValue, List<T> newComponents) {
        if (newComponents.size() != this.getComponents().size()) {
            this.getRoot().discardWithException(new IllegalArgumentException());
        }
        return (subT)this.rebuildAll(() -> ((AbstractVertex)this.getMeta()).bindInstance((Class)null, this.isThrowExistException(), (List)new Statics.Supers(this.getSupers(), supersToAdd), newValue, (List)newComponents), this.computeDependencies());
    }

    protected LinkedHashSet<T> computeDependencies() {
        return new DependenciesComputer<T, U>(){
            private static final long serialVersionUID = 4116681784718071815L;

            @Override
            boolean checkDependency(T node) {
                return AbstractVertex.this.isAncestorOf(node);
            }
        }.visit((AbstractVertex)this.getMeta());
    }

    protected LinkedHashSet<T> computePotentialDependencies(final Serializable value, final List<T> components) {
        return new DependenciesComputer<T, U>(){
            private static final long serialVersionUID = -3611136800445783634L;

            @Override
            boolean checkDependency(T node) {
                return node.dependsFrom((AbstractVertex)AbstractVertex.this, value, components);
            }
        }.visit(this);
    }

    @Override
    public <subT extends T> subT bindInstance(Class<?> clazz, boolean throwExistException, List<T> overrides, Serializable value, List<T> components) {
        this.checkSameEngine(components);
        this.checkSameEngine(overrides);
        AbstractVertex nearestMeta = (AbstractVertex)this.adjustMeta(overrides, value, components);
        if (nearestMeta != this) {
            return (subT)nearestMeta.bindInstance((Class)clazz, throwExistException, (List)overrides, value, (List)components);
        }
        AbstractVertex weakInstance = (AbstractVertex)this.getWeakInstance(value, components);
        if (weakInstance != null) {
            if (throwExistException) {
                this.getRoot().discardWithException(new ExistsException("Attempts to add an already existing instance : " + weakInstance.info()));
            } else {
                return (subT)(weakInstance.equiv(this, value, components) ? weakInstance : weakInstance.update(overrides, value, components));
            }
        }
        return (subT)this.rebuildAll(() -> ((AbstractVertex)this.buildInstance(clazz, throwExistException, overrides, value, components)).plug(), nearestMeta.computePotentialDependencies(value, components));
    }

    private <subT extends T> subT rebuildAll(Supplier<subT> rebuilder, LinkedHashSet<T> dependenciesToRebuild) {
        ConvertMap convertMap = new ConvertMap();
        dependenciesToRebuild.forEach(this::simpleRemove);
        AbstractVertex build = (AbstractVertex)rebuilder.get();
        dependenciesToRebuild.remove(this);
        convertMap.put(this, build);
        dependenciesToRebuild.forEach(x -> convertMap.convert(x));
        return (subT)build;
    }

    @Override
    public <subT extends T> subT addInstance(List<T> overrides, Serializable value, T ... components) {
        return (subT)this.bindInstance((Class)null, true, (List)overrides, value, (List)Arrays.asList(components));
    }

    @Override
    public <subT extends T> subT setInstance(List<T> overrides, Serializable value, T ... components) {
        return (subT)this.bindInstance((Class)null, false, (List)overrides, value, (List)Arrays.asList(components));
    }

    @Override
    public Snapshot<T> getInheritings(T origin, int level) {
        return () -> new InheritanceComputer(this, (AbstractVertex)origin, level).inheritanceIterator();
    }

    protected abstract <subT extends T> subT newT(Class<?> var1);

    protected abstract <subT extends T> subT[] newTArray(int var1);

    @Override
    public T[] coerceToArray(Object ... array) {
        AbstractVertex[] result = this.newTArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (AbstractVertex)array[i];
        }
        return result;
    }

    @Override
    public T[] targetsToComponents(T ... targets) {
        AbstractVertex[] components = this.newTArray(targets.length + 1);
        components[0] = this;
        System.arraycopy(targets, 0, components, 1, targets.length);
        return components;
    }

    <subT extends T> subT buildInstance(Class<?> clazz, boolean throwExistException, List<T> overrides, Serializable value, List<T> components) {
        int level = this.getLevel() == 0 && Objects.equals(this.getValue(), this.getRoot().getValue()) && this.getComponentsStream().allMatch(c -> c.isRoot()) && Objects.equals(value, this.getRoot().getValue()) && components.stream().allMatch(c -> c.isRoot()) ? 0 : this.getLevel() + 1;
        overrides.forEach(AncestorsService::checkIsAlive);
        components.forEach(AncestorsService::checkIsAlive);
        ArrayList supers = new ArrayList(new SupersComputer(level, this, overrides, value, components));
        this.checkOverridesAreReached(overrides, supers);
        return this.newT(clazz, throwExistException, this, supers, value, components);
    }

    void checkOverridesAreReached(List<T> overrides, List<T> supers) {
        if (!Statics.areOverridesReached(overrides, supers)) {
            this.getRoot().discardWithException(new IllegalStateException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
    }

    static <T extends VertexService<T, U>, U extends RootService<T, U>> boolean componentsDepends(SingularsLazyCache singulars, List<T> subComponents, List<T> superComponents) {
        int subIndex = 0;
        block0: for (VertexService superComponent : superComponents) {
            while (subIndex < subComponents.size()) {
                VertexService subComponent = (VertexService)subComponents.get(subIndex);
                if (subComponent.isSpecializationOf(superComponent)) {
                    if (singulars.get(subIndex)) {
                        return true;
                    }
                    ++subIndex;
                    continue block0;
                }
                ++subIndex;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean componentsDepends(final List<T> subComponents, List<T> superComponents) {
        class SingularsLazyCacheImpl
        implements SingularsLazyCache {
            private final Boolean[] singulars;

            SingularsLazyCacheImpl() {
                this.singulars = new Boolean[subComponents.size()];
            }

            @Override
            public boolean get(int i) {
                return this.singulars[i] != null ? this.singulars[i] : Boolean.valueOf(AbstractVertex.this.isSingularConstraintEnabled(i));
            }
        }
        return AbstractVertex.componentsDepends(new SingularsLazyCacheImpl(), subComponents, superComponents);
    }

    @Override
    public boolean isSuperOf(T subMeta, List<T> overrides, Serializable subValue, List<T> subComponents) {
        return overrides.stream().anyMatch(override -> override.inheritsFrom(this)) || AbstractVertex.isSuperOf(subMeta, subValue, subComponents, (AbstractVertex)this.getMeta(), this.getValue(), this.getComponents());
    }

    @Override
    public boolean inheritsFrom(T superMeta, Serializable superValue, List<T> superComponents) {
        return AbstractVertex.isSuperOf((AbstractVertex)this.getMeta(), this.getValue(), this.getComponents(), superMeta, superValue, superComponents);
    }

    private static <T extends AbstractVertex<T, U>, U extends RootService<T, U>> boolean isSuperOf(T subMeta, Serializable subValue, List<T> subComponents, T superMeta, Serializable superValue, List<T> superComponents) {
        if (!subMeta.inheritsFrom(superMeta)) {
            return false;
        }
        if (!((AbstractVertex)subMeta).componentsDepends(subComponents, superComponents)) {
            return false;
        }
        return subMeta.getValuesBiPredicate().test(subValue, superValue);
    }

    @Override
    public Snapshot<T> getComposites() {
        return () -> this.getMetaComposites().stream().map(entry -> ((Dependencies)entry.getValue()).stream()).flatMap(x -> x).iterator();
    }

    @Override
    public Snapshot<T> getMetaComposites(T meta) {
        return () -> {
            for (Dependencies.DependenciesEntry dependenciesEntry : this.getMetaComposites()) {
                if (!meta.equals(dependenciesEntry.getKey())) continue;
                return ((Dependencies)dependenciesEntry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    @Override
    public Snapshot<T> getSuperComposites(T superT) {
        return () -> {
            for (Dependencies.DependenciesEntry dependenciesEntry : this.getSuperComposites()) {
                if (!superT.equals(dependenciesEntry.getKey())) continue;
                return ((Dependencies)dependenciesEntry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    public <subT extends T> subT plug() {
        AbstractVertex result = ((AbstractVertex)this.getMeta()).indexInstance(this);
        this.getSupersStream().forEach(superGeneric -> superGeneric.indexInheriting(this));
        this.getComponentsStream().forEach(component -> component.indexByMeta((AbstractVertex)this.getMeta(), this));
        this.getSupersStream().forEach(superGeneric -> this.getComponentsStream().forEach(component -> component.indexBySuper(superGeneric, this)));
        return (subT)result;
    }

    public boolean unplug() {
        boolean result = ((AbstractVertex)this.getMeta()).unIndexInstance(this);
        if (!result) {
            this.getRoot().discardWithException(new NotFoundException(this.info()));
        }
        this.getSupersStream().forEach(superGeneric -> superGeneric.unIndexInheriting(this));
        this.getComponentsStream().forEach(component -> component.unIndexByMeta((AbstractVertex)this.getMeta(), this));
        this.getSupersStream().forEach(superGeneric -> this.getComponentsStream().forEach(component -> component.unIndexBySuper(superGeneric, this)));
        return result;
    }

    private T indexByMeta(T meta, T composite) {
        return AbstractVertex.index(this.getMetaComposites(), meta, composite);
    }

    private T indexBySuper(T superVertex, T composite) {
        return AbstractVertex.index(this.getSuperComposites(), superVertex, composite);
    }

    private static <T extends AbstractVertex<T, U>, U extends RootService<T, U>> T index(Dependencies<Dependencies.DependenciesEntry<T>> multimap, T index, T composite) {
        for (Dependencies.DependenciesEntry dependenciesEntry : multimap) {
            if (!index.equals(dependenciesEntry.getKey())) continue;
            return ((Dependencies)dependenciesEntry.getValue()).set(composite);
        }
        Dependencies dependencies = composite.buildDependencies();
        AbstractVertex abstractVertex = (AbstractVertex)dependencies.set(composite);
        multimap.set(new Dependencies.DependenciesEntry<T>(index, dependencies));
        return (T)abstractVertex;
    }

    private static <T> boolean unIndex(Dependencies<Dependencies.DependenciesEntry<T>> multimap, T index, T composite) {
        for (Dependencies.DependenciesEntry dependenciesEntry : multimap) {
            if (!index.equals(dependenciesEntry.getKey())) continue;
            return ((Dependencies)dependenciesEntry.getValue()).remove(composite);
        }
        return false;
    }

    private boolean unIndexByMeta(T meta, T composite) {
        return AbstractVertex.unIndex(this.getMetaComposites(), meta, composite);
    }

    private boolean unIndexBySuper(T superT, T composite) {
        return AbstractVertex.unIndex(this.getSuperComposites(), superT, composite);
    }

    private static <T> T index(Dependencies<T> dependencies, T dependency) {
        return dependencies.set(dependency);
    }

    private static <T> boolean unIndex(Dependencies<T> dependencies, T dependency) {
        return dependencies.remove(dependency);
    }

    @Override
    public Snapshot<T> getInstances() {
        return this.getInstancesDependencies();
    }

    @Override
    public Snapshot<T> getInheritings() {
        return this.getInheritingsDependencies();
    }

    private T indexInstance(T instance) {
        return (T)((AbstractVertex)AbstractVertex.index(this.getInstancesDependencies(), instance));
    }

    private T indexInheriting(T inheriting) {
        return (T)((AbstractVertex)AbstractVertex.index(this.getInheritingsDependencies(), inheriting));
    }

    private boolean unIndexInstance(T instance) {
        return AbstractVertex.unIndex(this.getInstancesDependencies(), instance);
    }

    private boolean unIndexInheriting(T inheriting) {
        return AbstractVertex.unIndex(this.getInheritingsDependencies(), inheriting);
    }

    static interface SingularsLazyCache {
        public boolean get(int var1);
    }

    private static class ConvertMap<T extends AbstractVertex<T, U>, U extends RootService<T, U>>
    extends HashMap<T, T> {
        private static final long serialVersionUID = 5003546962293036021L;

        private ConvertMap() {
        }

        T convert(T dependency) {
            if (dependency.isAlive()) {
                return dependency;
            }
            AbstractVertex newDependency = (AbstractVertex)this.get(dependency);
            if (newDependency == null) {
                Object meta = dependency.isRoot() ? dependency : this.convert((AbstractVertex)((Signature)dependency).getMeta());
                newDependency = ((AbstractVertex)((AbstractVertex)meta).buildInstance(null, ((Signature)dependency).isThrowExistException(), dependency.getSupersStream().map(x -> this.convert(x)).collect(Collectors.toList()), ((Signature)dependency).getValue(), dependency.getComponentsStream().map(x -> x.equals(this) ? null : this.convert(x)).collect(Collectors.toList()))).plug();
                this.put(dependency, newDependency);
            }
            return (T)newDependency;
        }
    }
}

