/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public interface SystemPropertiesService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    @Override
    default public T enableSystemProperty(Class<?> propertyClass, int pos) {
        if (!1.$assertionsDisabled && !this.isStructural()) {
            throw new AssertionError();
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.TRUE);
        return (T)((VertexService)this);
    }

    @Override
    default public T disableSystemProperty(Class<?> propertyClass, int pos) {
        if (!1.$assertionsDisabled && !this.isStructural()) {
            throw new AssertionError();
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.FALSE);
        return (T)((VertexService)this);
    }

    @Override
    default public boolean isSystemPropertyEnabled(Class<?> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    @Override
    default public T enableReferentialIntegrity(int pos) {
        return (T)this.enableSystemProperty((Class)ReferentialIntegrityConstraint.class, pos);
    }

    @Override
    default public T disableReferentialIntegrity(int pos) {
        return (T)this.disableSystemProperty((Class)ReferentialIntegrityConstraint.class, pos);
    }

    @Override
    default public boolean isReferentialIntegrityConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(ReferentialIntegrityConstraint.class, pos);
    }

    @Override
    default public T enableSingularConstraint(int pos) {
        return (T)this.enableSystemProperty((Class)SingularConstraint.class, pos);
    }

    @Override
    default public T disableSingularConstraint(int pos) {
        return (T)this.disableSystemProperty((Class)SingularConstraint.class, pos);
    }

    @Override
    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    @Override
    default public T enablePropertyConstraint() {
        return (T)this.enableSystemProperty((Class)PropertyConstraint.class, -1);
    }

    @Override
    default public T disablePropertyConstraint() {
        return (T)this.disableSystemProperty((Class)PropertyConstraint.class, -1);
    }

    @Override
    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    @Override
    default public T enableRequiredConstraint(int pos) {
        return (T)this.enableSystemProperty((Class)RequiredConstraint.class, pos);
    }

    @Override
    default public T disableRequiredConstraint(int pos) {
        return (T)this.disableSystemProperty((Class)RequiredConstraint.class, pos);
    }

    @Override
    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    @Override
    default public T enableCascadeRemove(int pos) {
        return (T)this.enableSystemProperty((Class)CascadeRemoveProperty.class, pos);
    }

    @Override
    default public T disableCascadeRemove(int pos) {
        return (T)this.disableSystemProperty((Class)CascadeRemoveProperty.class, pos);
    }

    @Override
    default public boolean isCascadeRemove(int pos) {
        return this.isSystemPropertyEnabled(CascadeRemoveProperty.class, pos);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    static class 1 {
    }

    public static class AxedPropertyClass
    implements Serializable {
        private static final long serialVersionUID = -2631066712866842794L;
        private final Class<?> clazz;
        private final int axe;

        public AxedPropertyClass(Class<?> clazz, int axe) {
            this.clazz = clazz;
            this.axe = axe;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getAxe() {
            return this.axe;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AxedPropertyClass)) {
                return false;
            }
            AxedPropertyClass compare = (AxedPropertyClass)obj;
            return this.clazz.equals(compare.getClazz()) && this.axe == compare.axe;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            return "{class : " + this.clazz.getSimpleName() + ", axe : " + this.axe + "}";
        }
    }

    public static class CascadeRemoveProperty
    implements SystemProperty {
    }

    public static class RequiredConstraint
    implements Constraint {
    }

    public static class PropertyConstraint
    implements Constraint {
    }

    public static class SingularConstraint
    implements Constraint {
    }

    public static class ReferentialIntegrityConstraint
    implements Constraint {
    }

    public static interface Constraint
    extends SystemProperty {
    }

    public static interface SystemProperty {
    }
}

