/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public interface DisplayService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    @Override
    default public String info() {
        return "(" + ((VertexService)this.getMeta()).getValue() + ")" + this.getSupers() + this + this.getComponents() + " ";
    }

    @Override
    default public void log() {
        log.info(this.detailedInfo());
    }

    @Override
    default public void log(String prefix) {
        log.info(prefix + this.detailedInfo());
    }

    @Override
    default public String detailedInfo() {
        String s = "\n\n*******************************" + System.identityHashCode(this) + "******************************\n";
        s = s + " Value       : " + this.getValue() + "\n";
        s = s + " Meta        : " + this.getMeta() + " (" + System.identityHashCode(this.getMeta()) + ")\n";
        s = s + " MetaLevel   : " + Statics.getMetaLevelString(this.getLevel()) + "\n";
        s = s + " Category    : " + Statics.getCategoryString(this.getLevel(), this.getComponents().size()) + "\n";
        s = s + " Class       : " + this.getClass().getName() + "\n";
        s = s + "**********************************************************************\n";
        for (VertexService superGeneric : this.getSupers()) {
            s = s + " Super       : " + superGeneric + " (" + System.identityHashCode(superGeneric) + ")\n";
        }
        for (VertexService component : this.getComponents()) {
            s = s + " Component   : " + component + " (" + System.identityHashCode(component) + ")\n";
        }
        s = s + "**********************************************************************\n";
        return s;
    }
}

