/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.services.ApiService;
import org.genericsystem.kernel.services.RootService;
import org.genericsystem.kernel.services.VertexService;

public interface DependenciesService<T extends VertexService<T, U>, U extends RootService<T, U>>
extends ApiService<T, U> {
    @Override
    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isRoot() && this.isAncestorOf((T)((VertexService)dependency.getMeta())) || dependency.getSupersStream().anyMatch(this::isAncestorOf) || dependency.getComponentsStream().filter(component -> !dependency.equals(component)).anyMatch(this::isAncestorOf);
    }

    default public boolean dependsFrom(T meta, Serializable value, List<T> components) {
        return this.inheritsFrom(meta, value, components) || this.getComponentsStream().filter(component -> component != null && component != this).anyMatch(component -> component.dependsFrom(meta, value, components)) || !this.isRoot() && ((VertexService)this.getMeta()).dependsFrom(meta, value, components);
    }

    default public Stream<T> select() {
        return Stream.of((VertexService)this);
    }

    @Override
    default public Snapshot<T> getAllInheritings() {
        return () -> Stream.concat(this.select(), Statics.concat(this.getInheritings().stream(), inheriting -> inheriting.getAllInheritings().stream()).distinct()).iterator();
    }

    @Override
    default public Snapshot<T> getAllInstances() {
        return () -> this.getAllInheritings().stream().map(inheriting -> inheriting.getInstances().stream()).flatMap(x -> x).iterator();
    }
}

