/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.kernel.exceptions.ExistsException;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.BindingService;
import org.genericsystem.kernel.services.FactoryService;

public interface UpdatableService<T extends UpdatableService<T>>
extends BindingService<T> {
    default public T updateValue(Serializable newValue) {
        return this.update(this.getSupers(), newValue, this.getComponents());
    }

    default public T updateSupers(T ... supersToAdd) {
        return this.update(Arrays.asList(supersToAdd), this.getValue(), this.getComponents());
    }

    default public T updateComponents(T ... newComponents) {
        return (T)this.update(this.getSupers(), this.getValue(), (UpdatableService[])newComponents);
    }

    default public T update(List<T> supersToAdd, Serializable newValue, T ... newComponents) {
        return this.update(supersToAdd, newValue, Arrays.asList(newComponents));
    }

    default public T update(Serializable newValue, T ... newComponents) {
        return this.update(Collections.emptyList(), newValue, Arrays.asList(newComponents));
    }

    default public T update(List<T> supersToAdd, Serializable newValue, List<T> newComponents) {
        if (newComponents.size() != this.getComponents().size()) {
            this.rollbackAndThrowException(new IllegalArgumentException());
        }
        return (T)this.rebuildAll(() -> (UpdatableService)((UpdatableService)((UpdatableService)this.buildInstance()).init((FactoryService)this.getMeta(), new Supers(this.getSupers(), supersToAdd), newValue, newComponents)).plug());
    }

    default public T rebuildAll(Supplier<T> rebuilder) {
        HashMap<UpdatableService, UpdatableService> convertMap = new HashMap<UpdatableService, UpdatableService>();
        LinkedHashSet<UpdatableService> dependenciesToRebuild = this.computeAllDependencies();
        dependenciesToRebuild.forEach(BindingService::unplug);
        UpdatableService build = (UpdatableService)rebuilder.get();
        dependenciesToRebuild.remove(this);
        convertMap.put(this, build);
        dependenciesToRebuild.forEach(x -> x.getOrBuild(convertMap));
        return (T)build;
    }

    default public T rebuildAll(Supplier<T> rebuilder, List<T> overrides, Serializable value, List<T> components) {
        HashMap<UpdatableService, UpdatableService> convertMap = new HashMap<UpdatableService, UpdatableService>();
        LinkedHashSet<UpdatableService> dependenciesToRebuild = this.computeAllDependencies(overrides, value, components);
        dependenciesToRebuild.forEach(BindingService::unplug);
        UpdatableService build = (UpdatableService)rebuilder.get();
        convertMap.put(this, build);
        dependenciesToRebuild.forEach(x -> x.getOrBuild(convertMap));
        return (T)build;
    }

    default public T getOrBuild(Map<T, T> convertMap) {
        if (this.isAlive()) {
            return (T)this;
        }
        UpdatableService<T> newDependency = (UpdatableService)convertMap.get(this);
        if (newDependency == null) {
            newDependency = this.build(convertMap);
            convertMap.put(this, newDependency);
        }
        return (T)newDependency;
    }

    default public T build(Map<T, T> convertMap) {
        UpdatableService meta = this == this.getMeta() ? this : ((UpdatableService)this.getMeta()).getOrBuild(convertMap);
        return (T)((UpdatableService)((UpdatableService)meta.buildInstance(this.getSupersStream().map(x -> x.getOrBuild(convertMap)).collect(Collectors.toList()), this.getValue(), this.getComponentsStream().map(x -> x.equals(this) ? null : (UpdatableService)x.getOrBuild(convertMap)).collect(Collectors.toList()))).plug());
    }

    default public T setInstance(Serializable value, T ... components) {
        return (T)this.setInstance(Collections.emptyList(), value, (UpdatableService[])components);
    }

    default public T setInstance(T override, Serializable value, T ... components) {
        return (T)this.setInstance(Collections.singletonList(override), value, (UpdatableService[])components);
    }

    default public T setInstance(List<T> overrides, Serializable value, T ... components) {
        this.checkSameEngine(Arrays.asList(components));
        this.checkSameEngine(overrides);
        UpdatableService nearestMeta = (UpdatableService)this.adjustMeta(overrides, value, Arrays.asList(components));
        if (nearestMeta != this) {
            return (T)nearestMeta.setInstance(overrides, value, (UpdatableService[])components);
        }
        UpdatableService weakInstance = (UpdatableService)this.getWeakInstance(value, (BindingService[])components);
        if (weakInstance != null) {
            if (weakInstance.equiv(this, value, Arrays.asList(components))) {
                return (T)weakInstance;
            }
            return (T)weakInstance.update(overrides, value, (UpdatableService[])components);
        }
        return (T)this.addInstance(overrides, value, (UpdatableService[])components);
    }

    default public T getMetaAttribute() {
        UpdatableService root = (UpdatableService)this.getRoot();
        return (T)((UpdatableService)root.getInstance(root.getValue(), new UpdatableService[]{root}));
    }

    default public T addInstance(Serializable value, T ... components) {
        return (T)this.addInstance(Collections.emptyList(), value, (UpdatableService[])components);
    }

    default public T addInstance(T superGeneric, Serializable value, T ... components) {
        return (T)this.addInstance(Collections.singletonList(superGeneric), value, (UpdatableService[])components);
    }

    default public T addInstance(List<T> overrides, Serializable value, T ... components) {
        this.checkSameEngine(Arrays.asList(components));
        this.checkSameEngine(overrides);
        UpdatableService nearestMeta = (UpdatableService)this.adjustMeta(overrides, value, Arrays.asList(components));
        if (nearestMeta != this) {
            return (T)nearestMeta.addInstance(overrides, value, (UpdatableService[])components);
        }
        UpdatableService weakInstance = (UpdatableService)this.getWeakInstance(value, (BindingService[])components);
        if (weakInstance != null) {
            this.rollbackAndThrowException(new ExistsException("Attempts to add an already existing instance : " + weakInstance.info()));
        }
        UpdatableService instance = (UpdatableService)this.buildInstance(overrides, value, Arrays.asList(components));
        return (T)instance.rebuildAll(() -> (UpdatableService)instance.plug());
    }

    public static class Supers<T extends UpdatableService<T>>
    extends ArrayList<T> {
        private static final long serialVersionUID = 6163099887384346235L;

        public Supers(List<T> adds) {
            adds.forEach(this::add);
        }

        public Supers(List<T> adds, T lastAdd) {
            this(adds);
            this.add(lastAdd);
        }

        public Supers(List<T> adds, List<T> otherAdds) {
            this(adds);
            otherAdds.forEach(this::add);
        }

        @Override
        public boolean add(T candidate) {
            for (UpdatableService element : this) {
                if (!element.inheritsFrom(candidate)) continue;
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!candidate.inheritsFrom((AncestorsService)((AncestorsService)it.next()))) continue;
                it.remove();
            }
            return super.add(candidate);
        }
    }
}

