/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import org.genericsystem.kernel.services.RemovableService;

public interface SystemPropertiesService<T extends SystemPropertiesService<T>>
extends RemovableService<T> {
    public Serializable getSystemPropertyValue(Class<?> var1, int var2);

    public void setSystemPropertyValue(Class<T> var1, int var2, Serializable var3);

    default public T enableSystemProperty(Class<?> propertyClass, int pos) {
        if (!1.$assertionsDisabled && !this.isStructural()) {
            throw new AssertionError();
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.TRUE);
        return (T)this;
    }

    default public T disableSystemProperty(Class<?> propertyClass, int pos) {
        if (!1.$assertionsDisabled && !this.isStructural()) {
            throw new AssertionError();
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.FALSE);
        return (T)this;
    }

    default public boolean isSystemPropertyEnabled(Class<?> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    default public T enableReferentialIntegrity(int pos) {
        return this.enableSystemProperty(ReferentialIntegrityConstraint.class, pos);
    }

    default public T disableReferentialIntegrity(int pos) {
        return this.disableSystemProperty(ReferentialIntegrityConstraint.class, pos);
    }

    @Override
    default public boolean isReferentialIntegrityConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(ReferentialIntegrityConstraint.class, pos);
    }

    default public T enableSingularConstraint(int pos) {
        return this.enableSystemProperty(SingularConstraint.class, pos);
    }

    default public T disableSingularConstraint(int pos) {
        return this.disableSystemProperty(SingularConstraint.class, pos);
    }

    @Override
    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    default public T enablePropertyConstraint() {
        return this.enableSystemProperty(PropertyConstraint.class, -1);
    }

    default public T disablePropertyConstraint() {
        return this.disableSystemProperty(PropertyConstraint.class, -1);
    }

    @Override
    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    default public T enableRequiredConstraint(int pos) {
        return this.enableSystemProperty(RequiredConstraint.class, pos);
    }

    default public T disableRequiredConstraint(int pos) {
        return this.disableSystemProperty(RequiredConstraint.class, pos);
    }

    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    default public T enableCascadeRemove(int pos) {
        return this.enableSystemProperty(CascadeRemoveProperty.class, pos);
    }

    default public T disableCascadeRemove(int pos) {
        return this.disableSystemProperty(CascadeRemoveProperty.class, pos);
    }

    @Override
    default public boolean isCascadeRemove(int pos) {
        return this.isSystemPropertyEnabled(CascadeRemoveProperty.class, pos);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    static class 1 {
    }

    public static class AxedPropertyClass
    implements Serializable {
        private static final long serialVersionUID = -2631066712866842794L;
        private final Class<?> clazz;
        private final int axe;

        public AxedPropertyClass(Class<?> clazz, int axe) {
            this.clazz = clazz;
            this.axe = axe;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getAxe() {
            return this.axe;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AxedPropertyClass)) {
                return false;
            }
            AxedPropertyClass compare = (AxedPropertyClass)obj;
            return this.clazz.equals(compare.getClazz()) && this.axe == compare.axe;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            return "{class : " + this.clazz.getSimpleName() + ", axe : " + this.axe + "}";
        }
    }

    public static class CascadeRemoveProperty
    implements SystemProperty {
    }

    public static class RequiredConstraint
    implements Constraint {
    }

    public static class PropertyConstraint
    implements Constraint {
    }

    public static class SingularConstraint
    implements Constraint {
    }

    public static class ReferentialIntegrityConstraint
    implements Constraint {
    }

    public static interface Constraint
    extends SystemProperty {
    }

    public static interface SystemProperty {
    }
}

