/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.genericsystem.kernel.services.DependenciesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SignatureService<T extends SignatureService<T>> {
    public static final Logger log = LoggerFactory.getLogger(SignatureService.class);
    public static final BiPredicate<Serializable, Serializable> VALUE_EQUALS = (X, Y) -> Objects.equals(X, Y);
    public static final BiPredicate<Serializable, Serializable> VALUE_IGNORED = (X, Y) -> true;
    public static final BiPredicate<Serializable, Serializable> KEY_EQUALS = (X, Y) -> X instanceof Map.Entry && Y instanceof Map.Entry && Objects.equals(((Map.Entry)((Object)X)).getKey(), ((Map.Entry)((Object)Y)).getKey());
    public static final BiPredicate<List<? extends SignatureService<?>>, List<? extends SignatureService<?>>> SIZE_EQUALS = (X, Y) -> X.size() == Y.size();

    public T getMeta();

    public Serializable getValue();

    public List<T> getComponents();

    default public Stream<T> getComponentsStream() {
        return this.getComponents().stream();
    }

    default public boolean isRoot() {
        return false;
    }

    default public boolean isAlive() {
        return this.equals(this.getAlive());
    }

    default public T getAlive() {
        T pluggedMeta = this.getMeta().getAlive();
        if (pluggedMeta == null) {
            return null;
        }
        for (SignatureService instance : ((DependenciesService)pluggedMeta).getInstances()) {
            if (!this.equiv(instance)) continue;
            return (T)instance;
        }
        return null;
    }

    default public T getWeakAlive() {
        T pluggedMeta = this.getMeta().getAlive();
        if (pluggedMeta == null) {
            return null;
        }
        for (SignatureService instance : ((DependenciesService)pluggedMeta).getInstances()) {
            if (!this.weakEquiv(instance)) continue;
            return (T)instance;
        }
        return null;
    }

    default public boolean equiv(SignatureService<? extends SignatureService<?>> service) {
        return service == null ? false : this.equiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    default public boolean equiv(SignatureService<?> meta, Serializable value, List<? extends SignatureService<?>> components) {
        return this.getMeta().equiv(meta) && Objects.equals(this.getValue(), value) && SignatureService.equivComponents(this.getComponents(), components);
    }

    public static boolean equivComponents(List<? extends SignatureService<?>> components, List<? extends SignatureService<?>> otherComponents) {
        if (otherComponents.size() != components.size()) {
            return false;
        }
        Iterator<? extends SignatureService<?>> otherComponentsIt = otherComponents.iterator();
        return components.stream().allMatch(x -> x.equiv((SignatureService)otherComponentsIt.next()));
    }

    default public boolean weakEquiv(SignatureService<? extends SignatureService<?>> service) {
        return service == this ? true : this.weakEquiv(service.getMeta(), service.getValue(), service.getComponents());
    }

    default public boolean weakEquiv(SignatureService<?> meta, Serializable value, List<? extends SignatureService<?>> components) {
        return this.getMeta().weakEquiv(meta) && this.getMeta().getWeakPredicate().test(this.getValue(), this.getComponents(), value, components);
    }

    default public WeakPredicate getWeakPredicate() {
        return (value, components, otherValue, otherComponents) -> this.singularOrReferential(components, otherComponents) || this.weakEquiv(components, otherComponents) && this.getValuesBiPredicate().test(value, otherValue);
    }

    default public boolean singularOrReferential(List<? extends SignatureService<?>> components, List<? extends SignatureService<?>> otherComponents) {
        if (components.size() != otherComponents.size()) {
            return false;
        }
        for (int i = 0; i < otherComponents.size(); ++i) {
            if (!this.isReferentialIntegrityConstraintEnabled(i) || !this.isSingularConstraintEnabled(i)) continue;
            return true;
        }
        return false;
    }

    default public boolean weakEquiv(List<? extends SignatureService<?>> components, List<? extends SignatureService<?>> otherComponents) {
        if (components.size() != otherComponents.size()) {
            return false;
        }
        Iterator<? extends SignatureService<?>> otherComponentsIt = otherComponents.iterator();
        return components.stream().allMatch(x -> x.weakEquiv((SignatureService)otherComponentsIt.next()));
    }

    public boolean isPropertyConstraintEnabled();

    public boolean isReferentialIntegrityConstraintEnabled(int var1);

    public boolean isSingularConstraintEnabled(int var1);

    default public BiPredicate<Serializable, Serializable> getValuesBiPredicate() {
        return this.isPropertyConstraintEnabled() ? VALUE_IGNORED : VALUE_EQUALS.or(KEY_EQUALS);
    }

    @FunctionalInterface
    public static interface WeakPredicate {
        public boolean test(Serializable var1, List<? extends SignatureService<?>> var2, Serializable var3, List<? extends SignatureService<?>> var4);
    }
}

